/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.datagen.v1.provider;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;

public abstract class FabricCodecDataProvider<T>
implements DataProvider {
    private final PackOutput.PathProvider pathResolver;
    private final CompletableFuture<HolderLookup.Provider> registriesFuture;
    private final Codec<T> codec;

    private FabricCodecDataProvider(PackOutput.PathProvider pathResolver, CompletableFuture<HolderLookup.Provider> registriesFuture, Codec<T> codec) {
        this.pathResolver = pathResolver;
        this.registriesFuture = Objects.requireNonNull(registriesFuture);
        this.codec = codec;
    }

    protected FabricCodecDataProvider(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registriesFuture, PackOutput.Target outputType, String directoryName, Codec<T> codec) {
        this(dataOutput.createPathProvider(outputType, directoryName), registriesFuture, codec);
    }

    protected FabricCodecDataProvider(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registriesFuture, ResourceKey<? extends Registry<?>> key, Codec<T> codec) {
        this(dataOutput.createRegistryElementsPathProvider(key), registriesFuture, codec);
    }

    public CompletableFuture<?> run(CachedOutput writer) {
        return this.registriesFuture.thenCompose(lookup -> {
            HashMap<Identifier, JsonElement> entries = new HashMap<Identifier, JsonElement>();
            RegistryOps ops = lookup.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
            BiConsumer<Identifier, Object> provider = (id, value) -> {
                JsonElement json = this.convert((Identifier)id, (T)value, (DynamicOps<JsonElement>)ops);
                JsonElement existingJson = entries.put((Identifier)id, json);
                if (existingJson != null) {
                    throw new IllegalArgumentException("Duplicate entry " + String.valueOf(id));
                }
            };
            this.configure((BiConsumer<Identifier, T>)provider, (HolderLookup.Provider)lookup);
            return this.write(writer, entries);
        });
    }

    protected abstract void configure(BiConsumer<Identifier, T> var1, HolderLookup.Provider var2);

    private JsonElement convert(Identifier id, T value, DynamicOps<JsonElement> ops) {
        DataResult dataResult = this.codec.encodeStart(ops, value);
        return (JsonElement)dataResult.mapError(message -> "Invalid entry %s: %s".formatted(id, message)).getOrThrow();
    }

    private CompletableFuture<?> write(CachedOutput writer, Map<Identifier, JsonElement> entries) {
        return CompletableFuture.allOf((CompletableFuture[])entries.entrySet().stream().map(entry -> {
            Path path = this.pathResolver.json((Identifier)entry.getKey());
            return DataProvider.saveStable((CachedOutput)writer, (JsonElement)((JsonElement)entry.getValue()), (Path)path);
        }).toArray(CompletableFuture[]::new));
    }
}

