/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.datagen.client;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.client.datagen.v1.builder.SoundTypeBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.include.com.google.common.base.Preconditions;

public final class SoundTypeBuilderImpl
implements SoundTypeBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SoundTypeBuilderImpl.class);
    private boolean replace = false;
    private @Nullable String subtitle;
    private final List<Entry> sounds = new ArrayList<Entry>();

    @Override
    public SoundTypeBuilder replace(boolean replace) {
        this.replace = replace;
        return this;
    }

    @Override
    public SoundTypeBuilder subtitle(@Nullable String subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    @Override
    public SoundTypeBuilder sound(SoundTypeBuilder.EntryBuilder sound) {
        Objects.requireNonNull(sound, "Sound must not be null.");
        this.sounds.add(((EntryBuilderImpl)sound).build(""));
        return this;
    }

    @Override
    public SoundTypeBuilder sound(SoundTypeBuilder.EntryBuilder sound, int count) {
        Objects.requireNonNull(sound, "Sound must not be null.");
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"Count must be greater than zero.");
        for (int i = 1; i <= count; ++i) {
            this.sounds.add(((EntryBuilderImpl)sound).build(Integer.toString(i)));
        }
        return this;
    }

    public SoundType build() {
        Preconditions.checkState((!this.sounds.isEmpty() ? 1 : 0) != 0, (Object)"Sound definition must have at least one sound file");
        for (Entry sound : this.sounds) {
            if (sound.type() != SoundTypeBuilder.RegistrationType.SOUND_EVENT) continue;
            BuiltInRegistries.SOUND_EVENT.getOptional(sound.name()).orElseThrow(() -> new IllegalStateException("Referenced sound event " + String.valueOf(sound.name()) + " does not exist"));
        }
        return new SoundType(this.sounds, this.replace, Optional.ofNullable(this.subtitle));
    }

    public static final class EntryBuilderImpl
    implements SoundTypeBuilder.EntryBuilder {
        private final Identifier id;
        private final SoundTypeBuilder.RegistrationType type;
        private float volume = 1.0f;
        private float pitch = 1.0f;
        private int attenuationDistance = 16;
        private int weight = 1;
        private boolean stream = false;
        private boolean preload = false;

        private EntryBuilderImpl(SoundTypeBuilder.RegistrationType type, Identifier id) {
            this.type = type;
            this.id = id;
        }

        public static SoundTypeBuilder.EntryBuilder create(SoundTypeBuilder.RegistrationType type, Identifier id) {
            return new EntryBuilderImpl(type, id);
        }

        public static SoundTypeBuilder.EntryBuilder ofFile(Identifier soundFile) {
            Objects.requireNonNull(soundFile, "Sound file/event id must not be null.");
            if (soundFile.getPath().indexOf(46) != -1) {
                LOGGER.warn("Sound file \"" + String.valueOf(soundFile) + "\" should not have a file extension and may result in the sound event not playing.");
            }
            return EntryBuilderImpl.create(SoundTypeBuilder.RegistrationType.FILE, soundFile);
        }

        public static SoundTypeBuilder.EntryBuilder ofEvent(SoundEvent event) {
            Objects.requireNonNull(event, "Sound event must not be null.");
            return EntryBuilderImpl.create(SoundTypeBuilder.RegistrationType.SOUND_EVENT, event.location());
        }

        public static SoundTypeBuilder.EntryBuilder ofEvent(Holder<SoundEvent> event) {
            Objects.requireNonNull(event, "Sound event key must not be null.");
            return EntryBuilderImpl.create(SoundTypeBuilder.RegistrationType.SOUND_EVENT, ((ResourceKey)event.unwrapKey().orElseThrow(() -> new IllegalArgumentException("Direct (non-registered) sound event cannot be added"))).identifier());
        }

        @Override
        public SoundTypeBuilder.EntryBuilder volume(float volume) {
            Preconditions.checkArgument((volume > 0.0f && volume <= 1.0f ? 1 : 0) != 0, (Object)"Sound volume must be greater than 0 and less than or equal to 1.");
            this.volume = volume;
            return this;
        }

        @Override
        public SoundTypeBuilder.EntryBuilder pitch(float pitch) {
            Preconditions.checkArgument((pitch >= 0.5f && pitch <= 2.0f ? 1 : 0) != 0, (Object)"Sound pitch must be between 0.5 and 2 (inclusive)");
            this.pitch = pitch;
            return this;
        }

        @Override
        public SoundTypeBuilder.EntryBuilder attenuationDistance(int attenuationDistance) {
            this.attenuationDistance = attenuationDistance;
            return this;
        }

        @Override
        public SoundTypeBuilder.EntryBuilder weight(int weight) {
            Preconditions.checkArgument((weight >= 1 ? 1 : 0) != 0, (Object)"Sound must have a weight of at least 1.");
            this.weight = weight;
            return this;
        }

        @Override
        public SoundTypeBuilder.EntryBuilder stream(boolean stream) {
            this.stream = stream;
            return this;
        }

        @Override
        public SoundTypeBuilder.EntryBuilder preload(boolean preload) {
            this.preload = preload;
            return this;
        }

        public Entry build(@Nullable String suffix) {
            return new Entry(this.id.withSuffix(suffix == null ? "" : suffix), this.type, this.volume, this.pitch, this.weight, this.attenuationDistance, this.stream, this.preload);
        }
    }

    public record Entry(Identifier name, SoundTypeBuilder.RegistrationType type, float volume, float pitch, int weight, int attenuationDistance, boolean stream, boolean preload) {
        private static final Codec<Entry> MAP_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Identifier.CODEC.fieldOf("name").forGetter(Entry::name), (App)SoundTypeBuilder.RegistrationType.CODEC.optionalFieldOf("type", (Object)SoundTypeBuilder.RegistrationType.FILE).forGetter(Entry::type), (App)Codec.floatRange((float)Float.MIN_VALUE, (float)1.0f).optionalFieldOf("volume", (Object)Float.valueOf(1.0f)).forGetter(Entry::volume), (App)Codec.floatRange((float)0.5f, (float)2.0f).optionalFieldOf("pitch", (Object)Float.valueOf(1.0f)).forGetter(Entry::pitch), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).optionalFieldOf("weight", (Object)1).forGetter(Entry::weight), (App)Codec.INT.optionalFieldOf("attenuation_distance", (Object)16).forGetter(Entry::attenuationDistance), (App)Codec.BOOL.optionalFieldOf("stream", (Object)false).forGetter(Entry::stream), (App)Codec.BOOL.optionalFieldOf("preload", (Object)false).forGetter(Entry::preload)).apply((Applicative)instance, Entry::new));
        private static final Codec<Entry> STRING_CODEC = Identifier.CODEC.xmap(id -> new Entry((Identifier)id, SoundTypeBuilder.RegistrationType.FILE, 1.0f, 1.0f, 1, 16, false, false), Entry::name);
        private static final Codec<Entry> CODEC = Codec.xor(STRING_CODEC, MAP_CODEC).xmap(Either::unwrap, sound -> {
            if (sound.type() != SoundTypeBuilder.RegistrationType.FILE || sound.volume() != 1.0f || sound.pitch() != 1.0f || sound.weight() != 1 || sound.attenuationDistance() != 16 || sound.stream() || sound.preload()) {
                return Either.right((Object)sound);
            }
            return Either.left((Object)sound);
        });
    }

    public record SoundType(List<Entry> sounds, boolean replace, Optional<String> subtitle) {
        public static final Codec<SoundType> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Entry.CODEC.listOf().fieldOf("sounds").forGetter(SoundType::sounds), (App)Codec.BOOL.optionalFieldOf("replace", (Object)false).forGetter(SoundType::replace), (App)Codec.STRING.optionalFieldOf("subtitle").forGetter(SoundType::subtitle)).apply((Applicative)instance, SoundType::new));
    }
}

