/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.datagen.loot;

import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.fabricmc.fabric.impl.datagen.FabricDataGenHelper;
import net.fabricmc.fabric.mixin.datagen.loot.EntityLootSubProviderAccessor;
import net.minecraft.class_1299;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7701;
import net.minecraft.class_7789;

public class ConditionEntityLootTableGenerator extends class_7789 {
	private final class_7789 parent;
	private final ResourceCondition[] conditions;

	public ConditionEntityLootTableGenerator(class_7789 parent, ResourceCondition[] conditions) {
		super(class_7701.field_40180.method_45383(), ((EntityLootSubProviderAccessor) parent).getRegistries());

		this.parent = parent;
		this.conditions = conditions;
	}

	@Override
	public void method_10400() {
		throw new UnsupportedOperationException("generate() should not be called.");
	}

	@Override
	public void method_46028(class_1299<?> entityType, class_5321<class_52> tableKey, class_52.class_53 lootTable) {
		FabricDataGenHelper.addConditions(lootTable, this.conditions);
		this.parent.method_46028(entityType, tableKey, lootTable);
	}
}
