/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin;

import net.fabricmc.fabric.impl.dimension.FabricDimensionInternals;
import net.minecraft.class_1297;
import net.minecraft.class_1946;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2700;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1946.class)
public abstract class MixinPortalForcer {
	@Shadow
	@Final
	private class_3218 world;

	@Inject(method = "usePortal", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/Entity;getLastPortalDirectionVector()Lnet/minecraft/util/math/Vec3d;"))
	private void onUsePortal(class_1297 teleported, float yaw, CallbackInfoReturnable<Boolean> cir) {
		FabricDimensionInternals.prepareDimensionalTeleportation(teleported);
	}

	@Inject(method = "getPortal", at = @At("HEAD"), cancellable = true)
	private void findEntityPlacement(class_2338 pos, class_243 velocity, class_2350 portalDir, double portalX, double portalY, boolean player, CallbackInfoReturnable<class_2700.class_4297> cir) {
		class_2700.class_4297 ret = FabricDimensionInternals.tryFindPlacement(this.world, portalDir, portalX, portalY);

		if (ret != null) {
			cir.setReturnValue(ret);
		}
	}
}
