/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.idremap;

import net.minecraft.class_2378;
import net.minecraft.class_2874;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

// NOTE: This probably goes into dimension-fixes
@Mixin(class_2874.class)
public abstract class MixinDimensionRawIndexFix {
	@Inject(at = @At("RETURN"), method = "byRawId", cancellable = true)
	private static void byRawId(final int id, final CallbackInfoReturnable<class_2874> info) {
		if (info.getReturnValue() == null || info.getReturnValue().method_12484() != id) {
			for (class_2874 dimension : class_2378.field_11155) {
				if (dimension.method_12484() == id) {
					info.setReturnValue(dimension);
					return;
				}
			}
		}
	}
}
