/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.dimension.v1;

import com.google.common.base.Preconditions;
import java.util.function.BiFunction;
import net.fabricmc.fabric.api.dimension.v1.EntityPlacer;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2869;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_4545;
import net.minecraft.class_4546;

public final class FabricDimensionType
extends class_2874 {
    private final EntityPlacer defaultPlacement;
    private int desiredRawId;
    private int fixedRawId;

    public static Builder builder() {
        return new Builder();
    }

    private FabricDimensionType(String suffix, String saveDir, Builder builder) {
        super(3, suffix, saveDir, builder.factory, builder.skyLight, builder.biomeAccessStrategy);
        this.defaultPlacement = builder.defaultPlacer;
    }

    public int getDesiredRawId() {
        return this.desiredRawId;
    }

    public int method_12484() {
        return this.fixedRawId;
    }

    public EntityPlacer getDefaultPlacement() {
        return this.defaultPlacement;
    }

    public static final class Builder {
        private EntityPlacer defaultPlacer;
        private BiFunction<class_1937, class_2874, ? extends class_2869> factory;
        private int desiredRawId = 0;
        private boolean skyLight = true;
        private class_4545 biomeAccessStrategy = class_4546.field_20644;

        private Builder() {
        }

        public Builder defaultPlacer(EntityPlacer defaultPlacer) {
            Preconditions.checkNotNull((Object)defaultPlacer);
            this.defaultPlacer = defaultPlacer;
            return this;
        }

        public Builder factory(BiFunction<class_1937, class_2874, ? extends class_2869> factory) {
            Preconditions.checkNotNull(factory);
            this.factory = factory;
            return this;
        }

        public Builder skyLight(boolean skyLight) {
            this.skyLight = skyLight;
            return this;
        }

        public Builder biomeAccessStrategy(class_4545 biomeAccessStrategy) {
            Preconditions.checkNotNull((Object)biomeAccessStrategy);
            this.biomeAccessStrategy = biomeAccessStrategy;
            return this;
        }

        public Builder desiredRawId(int desiredRawId) {
            this.desiredRawId = desiredRawId;
            return this;
        }

        public FabricDimensionType buildAndRegister(class_2960 dimensionId) {
            Preconditions.checkArgument((class_2378.field_11155.method_10223(dimensionId) == null ? 1 : 0) != 0);
            Preconditions.checkState((this.defaultPlacer != null ? 1 : 0) != 0, (Object)"No defaultPlacer has been specified!");
            Preconditions.checkState((this.factory != null ? 1 : 0) != 0, (Object)"No dimension factory has been specified!");
            String suffix = dimensionId.method_12836() + "_" + dimensionId.method_12832();
            String saveDir = "DIM_" + dimensionId.method_12836() + "_" + dimensionId.method_12832();
            FabricDimensionType built = new FabricDimensionType(suffix, saveDir, this);
            class_2378.method_10230((class_2378)class_2378.field_11155, (class_2960)dimensionId, (Object)((Object)built));
            if (this.desiredRawId != 0) {
                built.desiredRawId = this.desiredRawId;
            } else {
                built.desiredRawId = class_2378.field_11155.method_10249((Object)built) - 1;
            }
            built.fixedRawId = built.desiredRawId;
            return built;
        }
    }
}

