/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.dimension;

import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Objects;
import net.fabricmc.fabric.api.dimension.v1.FabricDimensionType;
import net.fabricmc.fabric.api.network.ServerSidePacketRegistry;
import net.fabricmc.fabric.impl.dimension.DimensionIdsHolder;
import net.fabricmc.fabric.impl.dimension.FabricDimensionInternals;
import net.fabricmc.fabric.impl.registry.RemapException;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_31;

public class DimensionIdsFixer {
    private static final Field FABRIC_DIMENSION_TYPE$RAW_ID;
    static final class_2960 ID;

    public static class_2487 apply(class_2487 savedIds) throws RemapException {
        Int2ObjectOpenHashMap fixedIds = new Int2ObjectOpenHashMap();
        ArrayList<FabricDimensionType> fabricDimensions = new ArrayList<FabricDimensionType>();
        class_2487 fabricDimensionIds = new class_2487();
        for (class_2960 id : class_2378.field_11155.method_10235()) {
            class_2874 dimensionType = Objects.requireNonNull(class_2874.method_12483((class_2960)id));
            if (dimensionType instanceof FabricDimensionType) {
                FabricDimensionType fabricDimension = (FabricDimensionType)dimensionType;
                fabricDimensions.add(fabricDimension);
                DimensionIdsFixer.setFixedRawId(fabricDimension, fabricDimension.getDesiredRawId());
                continue;
            }
            class_2960 existing = (class_2960)fixedIds.put(dimensionType.method_12484(), (Object)id);
            if (existing == null) continue;
            throw new RemapException("Two non-fabric dimensions have the same raw dim id (" + dimensionType.method_12484() + ") : " + existing + " and " + id);
        }
        for (String key : savedIds.method_10541()) {
            class_2960 dimId;
            int savedRawId = savedIds.method_10550(key);
            class_2960 existing = (class_2960)fixedIds.putIfAbsent(savedRawId, (Object)(dimId = new class_2960(key)));
            if (existing != null && !existing.equals((Object)dimId)) {
                throw new RemapException("Saved fabric dimension got replaced with a non-fabric one! " + dimId + " replaced with " + existing + " (raw id: " + savedRawId + ")");
            }
            class_2874 dim = class_2874.method_12483((class_2960)dimId);
            if (dim instanceof FabricDimensionType) {
                DimensionIdsFixer.setFixedRawId((FabricDimensionType)dim, savedRawId);
                continue;
            }
            FabricDimensionInternals.LOGGER.warn("A saved dimension has {}: {}", (Object)(dim == null ? "been removed" : "stopped using the dimensions API"), (Object)dimId);
            fabricDimensionIds.method_10569(dimId.toString(), savedRawId);
        }
        int nextFreeId = 0;
        for (FabricDimensionType fabricDimension : fabricDimensions) {
            int rawDimId = fabricDimension.method_12484();
            class_2960 dimId = Objects.requireNonNull(class_2874.method_12485((class_2874)fabricDimension));
            if (fixedIds.containsKey(rawDimId) && !((class_2960)fixedIds.get(rawDimId)).equals((Object)dimId)) {
                while (fixedIds.containsKey(nextFreeId)) {
                    ++nextFreeId;
                }
                DimensionIdsFixer.setFixedRawId(fabricDimension, nextFreeId);
                rawDimId = nextFreeId;
            }
            fixedIds.put(rawDimId, (Object)dimId);
            fabricDimensionIds.method_10569(dimId.toString(), rawDimId);
        }
        return fabricDimensionIds;
    }

    private static void setFixedRawId(FabricDimensionType fabricDimension, int rawId) {
        try {
            FABRIC_DIMENSION_TYPE$RAW_ID.setInt((Object)fabricDimension, rawId);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to fix a raw id on a FabricDimensionType", e);
        }
    }

    public static class_2596<?> createPacket(class_31 levelProperties) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10794(((DimensionIdsHolder)levelProperties).fabric_getDimensionIds());
        return ServerSidePacketRegistry.INSTANCE.toPacket(ID, buf);
    }

    static {
        ID = new class_2960("fabric", "dimension/sync");
        try {
            FABRIC_DIMENSION_TYPE$RAW_ID = FabricDimensionType.class.getDeclaredField("fixedRawId");
            FABRIC_DIMENSION_TYPE$RAW_ID.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

