/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.dimension;

import com.google.common.base.Preconditions;
import net.fabricmc.fabric.api.dimension.v1.EntityPlacer;
import net.fabricmc.fabric.api.dimension.v1.FabricDimensionType;
import net.fabricmc.fabric.mixin.EntityHooks;
import net.minecraft.class_1297;
import net.minecraft.class_2350;
import net.minecraft.class_2700;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FabricDimensionInternals {
    public static final boolean DEBUG = System.getProperty("fabric.dimension.debug", "false").equalsIgnoreCase("true");
    public static final Logger LOGGER = LogManager.getLogger();
    private static final ThreadLocal<class_1297> PORTAL_ENTITY = new ThreadLocal();
    private static EntityPlacer customPlacement;

    private FabricDimensionInternals() {
        throw new AssertionError();
    }

    public static void prepareDimensionalTeleportation(class_1297 entity) {
        Preconditions.checkNotNull((Object)entity);
        PORTAL_ENTITY.set(entity);
        EntityHooks access = (EntityHooks)entity;
        if (entity.method_5656() == null) {
            access.setLastPortalDirectionVector(entity.method_5720());
        }
        if (entity.method_5843() == null) {
            access.setLastPortalDirection(entity.method_5735());
        }
    }

    public static class_2700.class_4297 tryFindPlacement(class_3218 destination, class_2350 portalDir, double portalX, double portalY) {
        class_2700.class_4297 customTarget;
        Preconditions.checkNotNull((Object)destination);
        class_1297 teleported = PORTAL_ENTITY.get();
        PORTAL_ENTITY.set(null);
        if (teleported == null) {
            return null;
        }
        EntityPlacer customPlacement = FabricDimensionInternals.customPlacement;
        if (customPlacement != null && (customTarget = customPlacement.placeEntity(teleported, destination, portalDir, portalX, portalY)) != null) {
            return customTarget;
        }
        class_2874 dimType = destination.method_8597().method_12460();
        if (dimType instanceof FabricDimensionType) {
            class_2700.class_4297 defaultTarget = ((FabricDimensionType)dimType).getDefaultPlacement().placeEntity(teleported, destination, portalDir, portalX, portalY);
            if (defaultTarget == null) {
                throw new IllegalStateException("Mod dimension " + class_2874.method_12485((class_2874)dimType) + " returned an invalid teleport target");
            }
            return defaultTarget;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends class_1297> E changeDimension(E teleported, class_2874 dimension, EntityPlacer placement) {
        assert (!teleported.field_6002.field_9236) : "Entities can only be teleported on the server side";
        assert (Thread.currentThread() == ((class_3218)teleported.field_6002).method_8503().method_3777()) : "Entities must be teleported from the main server thread";
        try {
            customPlacement = placement;
            class_1297 class_12972 = teleported.method_5731(dimension);
            return (E)class_12972;
        }
        finally {
            customPlacement = null;
        }
    }
}

