/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.dimension;

import com.google.common.base.Preconditions;
import net.minecraft.class_1297;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5454;

public final class FabricDimensionInternals {
	private FabricDimensionInternals() {
		throw new AssertionError();
	}

	@SuppressWarnings("unchecked")
	public static <E extends class_1297> E changeDimension(E teleported, class_3218 dimension, class_5454 target) {
		Preconditions.checkArgument(!teleported.method_37908().field_9236, "Entities can only be teleported on the server side");
		Preconditions.checkArgument(Thread.currentThread() == ((class_3218) teleported.method_37908()).method_8503().method_3777(), "Entities must be teleported from the main server thread");

		try {
			((Teleportable) teleported).fabric_setCustomTeleportTarget(target);

			// Fast path for teleporting within the same dimension.
			if (teleported.method_37908() == dimension) {
				if (teleported instanceof class_3222 serverPlayerEntity) {
					serverPlayerEntity.field_13987.method_14363(target.field_25879.field_1352, target.field_25879.field_1351, target.field_25879.field_1350, target.field_25881, teleported.method_36455());
				} else {
					teleported.method_5808(target.field_25879.field_1352, target.field_25879.field_1351, target.field_25879.field_1350, target.field_25881, teleported.method_36455());
				}

				teleported.method_18799(target.field_25880);
				teleported.method_5847(target.field_25881);

				return teleported;
			}

			return (E) teleported.method_5731(dimension);
		} finally {
			((Teleportable) teleported).fabric_setCustomTeleportTarget(null);
		}
	}
}
