/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.entity.event.v1;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public final class ServerEntityWorldChangeEvents {
    public static final Event<AfterEntityChange> AFTER_ENTITY_CHANGE_WORLD = EventFactory.createArrayBacked(AfterEntityChange.class, callbacks -> (originalEntity, newEntity, origin, destination) -> {
        for (AfterEntityChange callback : callbacks) {
            callback.afterChangeWorld(originalEntity, newEntity, origin, destination);
        }
    });
    public static final Event<AfterPlayerChange> AFTER_PLAYER_CHANGE_WORLD = EventFactory.createArrayBacked(AfterPlayerChange.class, callbacks -> (player, origin, destination) -> {
        for (AfterPlayerChange callback : callbacks) {
            callback.afterChangeWorld(player, origin, destination);
        }
    });

    private ServerEntityWorldChangeEvents() {
    }

    @FunctionalInterface
    public static interface AfterPlayerChange {
        public void afterChangeWorld(ServerPlayer var1, ServerLevel var2, ServerLevel var3);
    }

    @FunctionalInterface
    public static interface AfterEntityChange {
        public void afterChangeWorld(Entity var1, Entity var2, ServerLevel var3, ServerLevel var4);
    }
}

