/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.eventsinteraction;

import net.fabricmc.fabric.api.event.player.*;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2824;
import net.minecraft.class_2885;
import net.minecraft.class_2886;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_634;
import net.minecraft.class_636;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_636.class)
public class MixinClientPlayerInteractionManager {
	@Shadow
	private class_310 client;
	@Shadow
	private class_634 networkHandler;
	@Shadow
	private class_1934 gameMode;

	@Inject(at = @At(value = "INVOKE", target = "Lnet/minecraft/world/GameMode;isCreative()Z", ordinal = 0), method = "attackBlock", cancellable = true)
	public void attackBlock(class_2338 pos, class_2350 direction, CallbackInfoReturnable<Boolean> info) {
		class_1269 result = AttackBlockCallback.EVENT.invoker().interact(client.field_1724, client.field_1687, class_1268.field_5808, pos, direction);
		if (result != class_1269.field_5811) {
			info.setReturnValue(result == class_1269.field_5812);
			info.cancel();
		}
	}

	@Inject(at = @At(value = "INVOKE", target = "Lnet/minecraft/world/GameMode;isCreative()Z", ordinal = 0), method = "method_2902", cancellable = true)
	public void method_2902(class_2338 pos, class_2350 direction, CallbackInfoReturnable<Boolean> info) {
		if (!gameMode.method_8386()) {
			return;
		}

		class_1269 result = AttackBlockCallback.EVENT.invoker().interact(client.field_1724, client.field_1687, class_1268.field_5808, pos, direction);
		if (result != class_1269.field_5811) {
			info.setReturnValue(result == class_1269.field_5812);
			info.cancel();
		}
	}

	@Inject(at = @At(value = "INVOKE", target = "Lnet/minecraft/client/network/ClientPlayerEntity;getStackInHand(Lnet/minecraft/util/Hand;)Lnet/minecraft/item/ItemStack;", ordinal = 0), method = "interactBlock", cancellable = true)
	public void interactBlock(class_746 player, class_638 world, class_1268 hand, class_3965 blockHitResult, CallbackInfoReturnable<class_1269> info) {
		class_1269 result = UseBlockCallback.EVENT.invoker().interact(player, world, hand, blockHitResult);
		if (result != class_1269.field_5811) {
			if (result == class_1269.field_5812) {
				this.networkHandler.method_2883(new class_2885(hand, blockHitResult));
			}
			info.setReturnValue(result);
			info.cancel();
		}
	}

	@Inject(at = @At(value = "INVOKE", target = "Lnet/minecraft/client/network/ClientPlayNetworkHandler;sendPacket(Lnet/minecraft/network/Packet;)V", ordinal = 0), method = "interactItem", cancellable = true)
	public void interactItem(class_1657 player, class_1937 world, class_1268 hand, CallbackInfoReturnable<class_1269> info) {
		class_1269 result = UseItemCallback.EVENT.invoker().interact(player, world, hand);
		if (result != class_1269.field_5811) {
			if (result == class_1269.field_5812) {
				this.networkHandler.method_2883(new class_2886(hand));
			}
			info.setReturnValue(result);
			info.cancel();
			return;
		}
	}

	@Inject(at = @At(value = "INVOKE", target = "Lnet/minecraft/client/network/ClientPlayNetworkHandler;sendPacket(Lnet/minecraft/network/Packet;)V", ordinal = 0), method = "attackEntity", cancellable = true)
	public void attackEntity(class_1657 player, class_1297 entity, CallbackInfo info) {
		class_1269 result = AttackEntityCallback.EVENT.invoker().interact(player, player.method_5770(), class_1268.field_5808 /* TODO */, entity, null);
		if (result != class_1269.field_5811) {
			if (result == class_1269.field_5812) {
				this.networkHandler.method_2883(new class_2824(entity));
			}
			info.cancel();
		}
	}

	@Inject(at = @At(value = "INVOKE", target = "Lnet/minecraft/client/network/ClientPlayNetworkHandler;sendPacket(Lnet/minecraft/network/Packet;)V", ordinal = 0), method = "interactEntityAtLocation", cancellable = true)
	public void interactEntityAtLocation(class_1657 player, class_1297 entity, class_3966 hitResult, class_1268 hand, CallbackInfoReturnable<class_1269> info) {
		class_1269 result = UseEntityCallback.EVENT.invoker().interact(player, player.method_5770(), hand, entity, hitResult);
		if (result != class_1269.field_5811) {
			if (result == class_1269.field_5812) {
				class_243 hitVec = hitResult.method_17784().method_1023(entity.field_5987, entity.field_6010, entity.field_6035);
				this.networkHandler.method_2883(new class_2824(entity, hand, hitVec));
			}
			info.setReturnValue(result);
			info.cancel();
			return;
		}
	}
}
