/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.event.interaction;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2626;
import net.minecraft.class_2846;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import net.minecraft.class_3965;

@Mixin(class_3225.class)
public class MixinServerPlayerInteractionManager {
	@Shadow
	public class_3218 world;
	@Shadow
	public class_3222 player;

	@Inject(at = @At("HEAD"), method = "processBlockBreakingAction", cancellable = true)
	public void startBlockBreak(class_2338 pos, class_2846.class_2847 playerAction, class_2350 direction, int i, CallbackInfo info) {
		if (playerAction != class_2846.class_2847.field_12968) return;
		class_1269 result = AttackBlockCallback.EVENT.invoker().interact(player, world, class_1268.field_5808, pos, direction);

		if (result != class_1269.field_5811) {
			// The client might have broken the block on its side, so make sure to let it know.
			this.player.field_13987.method_14364(new class_2626(world, pos));
			info.cancel();
		}
	}

	@Inject(at = @At("HEAD"), method = "interactBlock", cancellable = true)
	public void interactBlock(class_3222 player, class_1937 world, class_1799 stack, class_1268 hand, class_3965 blockHitResult, CallbackInfoReturnable<class_1269> info) {
		class_1269 result = UseBlockCallback.EVENT.invoker().interact(player, world, hand, blockHitResult);

		if (result != class_1269.field_5811) {
			info.setReturnValue(result);
			info.cancel();
			return;
		}
	}

	@Inject(at = @At("HEAD"), method = "interactItem", cancellable = true)
	public void interactItem(class_3222 player, class_1937 world, class_1799 stack, class_1268 hand, CallbackInfoReturnable<class_1269> info) {
		class_1271<class_1799> result = UseItemCallback.EVENT.invoker().interact(player, world, hand);

		if (result.method_5467() != class_1269.field_5811) {
			info.setReturnValue(result.method_5467());
			info.cancel();
			return;
		}
	}
}
