/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.event.interaction;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.api.event.client.player.ClientPickBlockApplyCallback;
import net.fabricmc.fabric.api.event.client.player.ClientPickBlockCallback;
import net.fabricmc.fabric.api.event.client.player.ClientPickBlockGatherCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_437;

@Mixin(class_310.class)
public abstract class MixinMinecraftClient {
	private boolean fabric_itemPickCancelled;

	@SuppressWarnings("deprecation")
	private class_1799 fabric_emulateOldPick() {
		class_310 client = (class_310) (Object) this;
		ClientPickBlockCallback.Container ctr = new ClientPickBlockCallback.Container(class_1799.field_8037);
		ClientPickBlockCallback.EVENT.invoker().pick(client.field_1724, client.field_1765, ctr);
		return ctr.getStack();
	}

	@Inject(at = @At("HEAD"), method = "doItemPick", cancellable = true)
	private void fabric_doItemPickWrapper(CallbackInfo info) {
		class_310 client = (class_310) (Object) this;

		// Do a "best effort" emulation of the old events.
		class_1799 stack = ClientPickBlockGatherCallback.EVENT.invoker().pick(client.field_1724, client.field_1765);

		// TODO: Remove in 0.3.0
		if (stack.method_7960()) {
			stack = fabric_emulateOldPick();
		}

		if (stack.method_7960()) {
			// fall through
		} else {
			info.cancel();

			// I don't like that we clone vanilla logic here, but it's our best bet for now.
			class_1661 playerInventory = client.field_1724.method_31548();

			if (client.field_1724.method_31549().field_7477 && class_437.method_25441() && client.field_1765.method_17783() == class_239.class_240.field_1332) {
				class_2586 be = client.field_1687.method_8321(((class_3965) client.field_1765).method_17777());

				if (be != null) {
					stack = addBlockEntityNbt(stack, be);
				}
			}

			stack = ClientPickBlockApplyCallback.EVENT.invoker().pick(client.field_1724, client.field_1765, stack);

			if (stack.method_7960()) {
				return;
			}

			if (client.field_1724.method_31549().field_7477) {
				playerInventory.method_7374(stack);
				client.field_1761.method_2909(client.field_1724.method_5998(class_1268.field_5808), 36 + playerInventory.field_7545);
			} else {
				int slot = playerInventory.method_7395(stack);

				if (slot >= 0) {
					if (class_1661.method_7380(slot)) {
						playerInventory.field_7545 = slot;
					} else {
						client.field_1761.method_2916(slot);
					}
				}
			}
		}
	}

	@Shadow
	public abstract void doItemPick();

	@Shadow
	public abstract class_1799 addBlockEntityNbt(class_1799 itemStack_1, class_2586 blockEntity_1);

	@ModifyVariable(at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/player/PlayerInventory;getSlotWithStack(Lnet/minecraft/item/ItemStack;)I"), method = "doItemPick", ordinal = 0)
	public class_1799 modifyItemPick(class_1799 stack) {
		class_310 client = (class_310) (Object) this;
		class_1799 result = ClientPickBlockApplyCallback.EVENT.invoker().pick(client.field_1724, client.field_1765, stack);
		fabric_itemPickCancelled = result.method_7960();
		return result;
	}

	@Inject(at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/player/PlayerInventory;getSlotWithStack(Lnet/minecraft/item/ItemStack;)I"), method = "doItemPick", cancellable = true)
	public void cancelItemPick(CallbackInfo info) {
		if (fabric_itemPickCancelled) {
			info.cancel();
		}
	}
}
