/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.event.interaction;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2824;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3966;

@Mixin(class_3244.class)
public class MixinServerPlayNetworkHandler {
	@Shadow
	public class_3222 player;

	@Inject(method = "onPlayerInteractEntity", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/Entity;interactAt(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/Hand;)Lnet/minecraft/util/ActionResult;"), cancellable = true)
	public void onPlayerInteractEntity(class_2824 packet, CallbackInfo info) {
		class_1937 world = player.method_5770();
		class_1297 entity = packet.method_12248((class_3218) world);

		if (entity != null) {
			class_3966 hitResult = new class_3966(entity, packet.method_12250().method_1031(entity.method_23317(), entity.method_23318(), entity.method_23321()));

			class_1269 result = UseEntityCallback.EVENT.invoker().interact(player, world, packet.method_12249(), entity, hitResult);

			if (result != class_1269.field_5811) {
				info.cancel();
			}
		}
	}
}
