/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.event.interaction;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.block.BlockPickInteractionAware;
import net.fabricmc.fabric.api.entity.EntityPickInteractionAware;
import net.fabricmc.fabric.api.event.client.player.ClientPickBlockGatherCallback;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public class InteractionEventsRouterClient implements ClientModInitializer {
	@Override
	public void onInitializeClient() {
		ClientPickBlockGatherCallback.EVENT.register(((player, result) -> {
			if (result instanceof class_3965 && result.method_17783() != class_239.class_240.field_1333) {
				class_1922 view = player.method_5770();
				class_2338 pos = ((class_3965) result).method_17777();
				class_2680 state = view.method_8320(pos);

				if (state.method_26204() instanceof BlockPickInteractionAware) {
					return (((BlockPickInteractionAware) state.method_26204()).getPickedStack(state, view, pos, player, result));
				}
			} else if (result instanceof class_3966) {
				class_1297 entity = ((class_3966) result).method_17782();

				if (entity instanceof EntityPickInteractionAware) {
					return ((EntityPickInteractionAware) entity).getPickedStack(player, result);
				}
			}

			return class_1799.field_8037;
		}));
	}
}
