/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.event.client.player;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_239;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

/**
 * This event is emitted at the beginning of the block picking process in
 * order to find any applicable ItemStack. The first non-empty ItemStack
 * will be returned, overriding vanilla behavior.
 *
 * <p>Note that this is called any time the pick key is pressed, even if there is no target block.
 * The {@link class_239} could be a {@link class_3965} or an {@link class_3966}.
 * If the hit missed, it will be a {@link class_3965} with {@linkplain class_3965#method_17783() type}
 * {@link class_3965.Type#field_1333}, so make sure to check for that.
 */
public interface ClientPickBlockGatherCallback {
	Event<ClientPickBlockGatherCallback> EVENT = EventFactory.createArrayBacked(ClientPickBlockGatherCallback.class,
			(listeners) -> (player, result) -> {
				for (ClientPickBlockGatherCallback event : listeners) {
					ItemStack stack = event.pick(player, result);

					if (stack != ItemStack.EMPTY && !stack.isEmpty()) {
						return stack;
					}
				}

				return ItemStack.EMPTY;
			}
	);

	class_1799 pick(class_1657 player, class_239 result);
}
