/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.event.interaction;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import net.fabricmc.fabric.api.event.player.PlayerPickItemEvents;
import net.minecraft.class_10370;
import net.minecraft.class_10371;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_4538;

@Mixin(class_3244.class)
public abstract class ServerGamePacketListenerImplMixin {
	@Shadow
	@Final
	private class_3222 player;

	@Shadow
	private void tryPickItem(class_1799 stack) {
		throw new AssertionError();
	}

	@WrapOperation(method = "handlePickItemFromBlock", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/block/state/BlockState;getCloneItemStack(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;Z)Lnet/minecraft/world/item/ItemStack;"))
	public class_1799 onPickItemFromBlock(class_2680 state, class_4538 world, class_2338 pos, boolean includeData, Operation<class_1799> operation, @Local(argsOnly = true) class_10370 packet) {
		class_1799 stack = PlayerPickItemEvents.BLOCK.invoker().onPickItemFromBlock(player, pos, state, packet.comp_3327());

		if (stack == null) {
			return operation.call(state, world, pos, includeData);
		} else if (!stack.method_7960()) {
			this.tryPickItem(stack);
		}

		// Prevent vanilla data-inclusion behavior
		return class_1799.field_8037;
	}

	@WrapOperation(method = "handlePickItemFromEntity", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/Entity;getPickResult()Lnet/minecraft/world/item/ItemStack;"))
	public class_1799 onPickItemFromEntity(class_1297 entity, Operation<class_1799> operation, @Local(argsOnly = true) class_10371 packet) {
		class_1799 stack = PlayerPickItemEvents.ENTITY.invoker().onPickItemFromEntity(player, entity, packet.comp_3329());

		if (stack == null) {
			return operation.call(entity);
		} else if (!stack.method_7960()) {
			this.tryPickItem(stack);
		}

		// Prevent vanilla data-inclusion behavior
		return class_1799.field_8037;
	}
}
