/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.event.player;

import org.jspecify.annotations.Nullable;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;

/**
 * Contains events triggered by players interact with item.
 */
public interface ItemEvents {
	/**
	 * Callback that runs when {@link class_1792#method_7884(class_1838)} is called within {@link class_1799#method_7981(class_1838)}.
	 */
	Event<UseOnCallback> USE_ON = EventFactory.createArrayBacked(UseOnCallback.class,
			(listeners) -> (useOnContext) -> {
				for (UseOnCallback event : listeners) {
					class_1269 result = event.useOn(useOnContext);

					if (result != null) {
						return result;
					}
				}

				return null;
			}
	);

	/**
	 * Callback that runs when {@link class_1792#method_7836(class_1937, class_1657, class_1268)} is called within {@link class_1799#method_7913(class_1937, class_1657, class_1268)}.
	 */
	Event<UseCallback> USE = EventFactory.createArrayBacked(UseCallback.class,
			(listeners) -> (level, player, interactionHand) -> {
				for (UseCallback event : listeners) {
					class_1269 result = event.use(level, player, interactionHand);

					if (result != null) {
						return result;
					}
				}

				return null;
			}
	);

	@FunctionalInterface
	interface UseOnCallback {
		/**
		 * Handles item-side interaction, caused by interacting with block.
		 *
		 * @param useOnContext the context of interaction.
		 * @return any {@link class_1269} to indicate that interaction was handler or null to pass it forward to other listeners and vanilla
		 */
		@Nullable
		class_1269 useOn(class_1838 useOnContext);
	}

	@FunctionalInterface
	interface UseCallback {
		/**
		 * Handles item interaction.
		 *
		 * @param level the level in which block resides
		 * @param player the player causing the interaction
		 * @param interactionHand player's hand used in interaction
		 * @return any {@link class_1269} to indicate that interaction was handler or null to pass it forward to other listeners and vanilla
		 */
		@Nullable
		class_1269 use(class_1937 level, class_1657 player, class_1268 interactionHand);
	}
}
