/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.gamerule;

import static net.minecraft.class_2170.method_9247;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.fabricmc.fabric.api.gamerule.v1.rule.EnumRule;
import net.fabricmc.fabric.mixin.gamerule.GameRuleCommandAccessor;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2561;

public final class EnumRuleCommand {
	public static <E extends Enum<E>> void register(LiteralArgumentBuilder<class_2168> literalArgumentBuilder, class_1928.class_4313<EnumRule<E>> key, EnumRuleType<E> type) {
		literalArgumentBuilder.then(method_9247(key.method_20771()).executes(context -> {
			// We can use the vanilla query method
			return GameRuleCommandAccessor.invokeExecuteQuery(context.getSource(), key);
		}));

		// The LiteralRuleType handles the executeSet
		type.register(literalArgumentBuilder, key);
	}

	public static <E extends Enum<E>> int executeAndSetEnum(CommandContext<class_2168> context, E value, class_1928.class_4313<EnumRule<E>> key) throws CommandSyntaxException {
		// Mostly copied from vanilla, but tweaked so we can use literals
		class_2168 serverCommandSource = context.getSource();
		EnumRule<E> rule = serverCommandSource.method_9211().method_3767().method_20746(key);

		try {
			rule.set(value, serverCommandSource.method_9211());
		} catch (IllegalArgumentException e) {
			throw new SimpleCommandExceptionType(class_2561.method_43470(e.getMessage())).create();
		}

		serverCommandSource.method_9226(class_2561.method_43469("commands.gamerule.set", key.method_20771(), rule.toString()), true);
		return rule.method_20781();
	}
}
