/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.gamerule.widget;

import java.util.List;
import net.fabricmc.fabric.api.gamerule.v1.rule.DoubleRule;
import net.fabricmc.fabric.mixin.gamerule.client.EditGameRulesScreenAccessor;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_4587;
import net.minecraft.class_5235;
import net.minecraft.class_5481;

public final class DoubleRuleWidget extends class_5235.class_5400 {
	private final class_342 textFieldWidget;

	public DoubleRuleWidget(class_5235 gameRuleScreen, class_2561 name, List<class_5481> description, final String ruleName, DoubleRule rule) {
		gameRuleScreen.super(description, name);
		EditGameRulesScreenAccessor accessor = (EditGameRulesScreenAccessor) gameRuleScreen;

		this.textFieldWidget = new class_342(class_310.method_1551().field_1772, 10, 5, 42, 20,
				name.method_27661()
				.method_27693("\n")
				.method_27693(ruleName)
				.method_27693("\n")
		);

		this.textFieldWidget.method_1852(Double.toString(rule.get()));
		this.textFieldWidget.method_1863(value -> {
			if (rule.validate(value)) {
				this.textFieldWidget.method_1868(0xE0E0E0);
				accessor.callMarkValid(this);
			} else {
				this.textFieldWidget.method_1868(0xFF0000);
				accessor.callMarkInvalid(this);
			}
		});

		this.field_25630.add(this.textFieldWidget);
	}

	@Override
	public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
		// FIXME: Param names nightmare
		this.method_29989(matrices, y, x);

		this.textFieldWidget.method_48229(x + entryWidth - 44, y);
		this.textFieldWidget.method_25394(matrices, mouseX, mouseY, tickDelta);
	}
}
