/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.gamerule.client;

import java.util.Locale;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import net.fabricmc.fabric.api.gamerule.v1.FabricGameRuleVisitor;
import net.fabricmc.fabric.api.gamerule.v1.rule.DoubleRule;
import net.fabricmc.fabric.api.gamerule.v1.rule.EnumRule;
import net.fabricmc.fabric.impl.gamerule.widget.DoubleRuleWidget;
import net.fabricmc.fabric.impl.gamerule.widget.EnumRuleWidget;
import net.minecraft.class_1074;
import net.minecraft.class_1928;
import net.minecraft.class_5235;

@Mixin(targets = "net/minecraft/client/gui/screen/world/EditGameRulesScreen$RuleListWidget$1")
public abstract class RuleListWidgetVisitorMixin implements class_1928.class_4311, FabricGameRuleVisitor {
	@Final
	@Shadow
	private class_5235 field_24314;
	@Shadow
	protected abstract <T extends class_1928.class_4315<T>> void createRuleWidget(class_1928.class_4313<T> key, class_5235.class_5238<T> ruleWidgetFactory);

	@Override
	public void visitDouble(class_1928.class_4313<DoubleRule> key, class_1928.class_4314<DoubleRule> type) {
		this.createRuleWidget(key, (name, description, ruleName, rule) -> {
			return new DoubleRuleWidget(this.field_24314, name, description, ruleName, rule);
		});
	}

	@Override
	public <E extends Enum<E>> void visitEnum(class_1928.class_4313<EnumRule<E>> key, class_1928.class_4314<EnumRule<E>> type) {
		this.createRuleWidget(key, (name, description, ruleName, rule) -> {
			return new EnumRuleWidget<>(this.field_24314, name, description, ruleName, rule, key.getTranslationKey());
		});
	}

	/**
	 * @reason We need to display an enum rule's default value as translated.
	 */
	@Redirect(at = @At(value = "INVOKE", target = "Lnet/minecraft/world/GameRules$Rule;serialize()Ljava/lang/String;"), method = "net/minecraft/client/gui/screen/world/EditGameRulesScreen$RuleListWidget$1.createRuleWidget(Lnet/minecraft/world/GameRules$Key;Lnet/minecraft/client/gui/screen/world/EditGameRulesScreen$RuleWidgetFactory;)V")
	private <T extends class_1928.class_4315<T>> String displayProperEnumName(class_1928.class_4315<T> rule, class_1928.class_4313<T> key, class_5235.class_5238<T> widgetFactory) {
		if (rule instanceof EnumRule) {
			String translationKey = key.method_27334() + "." + ((EnumRule<?>) rule).get().name().toLowerCase(Locale.ROOT);

			if (class_1074.method_4663(translationKey)) {
				return class_1074.method_4662(translationKey);
			}

			return ((EnumRule<?>) rule).get().toString();
		}

		return rule.method_20779();
	}
}
