/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.gamerule.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.api.gamerule.v1.CustomGameRuleCategory;
import net.minecraft.class_1928;
import net.minecraft.class_310;
import net.minecraft.class_5235;
import net.minecraft.class_5235.class_5237;

// For any future maintainers who wonder why this class does not compile because of jsr305, please reload gradle using `--refresh-dependencies`.
@Mixin(class_5235.class_5241.class)
public abstract class RuleListWidgetMixin extends net.minecraft.class_350<class_5235.class_5240> {
	@Unique
	private final Map<CustomGameRuleCategory, List<class_5235.class_5240>> fabricCategories = new HashMap<>();

	public RuleListWidgetMixin(class_310 client, int , int , int , int , int ) {
		super(client, , , , , );
	}

	@Inject(method = "<init>(Lnet/minecraft/client/gui/screen/world/EditGameRulesScreen;Lnet/minecraft/world/GameRules;)V", at = @At("TAIL"))
	private void initializeFabricGameruleCategories(class_5235 screen, class_1928 gameRules, CallbackInfo ci) {
		this.fabricCategories.forEach((category, widgetList) -> {
			this.method_25321(screen.new class_5237(category.getName()));

			for (class_5235.class_5240 widget : widgetList) {
				this.method_25321(widget);
			}
		});
	}

	@Inject(method = "method_27638(Ljava/util/Map$Entry;)V", at = @At("HEAD"), cancellable = true)
	private void ignoreKeysWithCustomCategories(Map.Entry<class_1928.class_4313<?>, class_5235.class_5240> entry, CallbackInfo ci) {
		final class_1928.class_4313<?> ruleKey = entry.getKey();
		CustomGameRuleCategory.getCategory(ruleKey).ifPresent(key -> {
			this.fabricCategories.computeIfAbsent(key, c -> new ArrayList<>()).add(entry.getValue());
			ci.cancel();
		});
	}
}
