/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.gamerule.v1.rule;

import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleRegistry;
import net.fabricmc.fabric.api.gamerule.v1.rule.ValidateableRule;
import net.minecraft.class_10961;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DoubleRule
extends class_1928.class_4315<DoubleRule>
implements ValidateableRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(GameRuleRegistry.class);
    private final double minimumValue;
    private final double maximumValue;
    private double value;

    @Deprecated
    public DoubleRule(class_1928.class_4314<DoubleRule> type, double value, double minimumValue, double maximumValue) {
        super(type);
        this.value = value;
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            throw new IllegalArgumentException("Value cannot be infinite or NaN");
        }
        if (Double.isInfinite(minimumValue) || Double.isNaN(minimumValue)) {
            throw new IllegalArgumentException("Minimum value cannot be infinite or NaN");
        }
        if (Double.isInfinite(maximumValue) || Double.isNaN(maximumValue)) {
            throw new IllegalArgumentException("Maximum value cannot be infinite or NaN");
        }
    }

    protected void method_20776(CommandContext<class_2168> context, String name) {
        this.value = (Double)context.getArgument(name, Double.class);
    }

    protected void method_20777(String value) {
        if (!value.isEmpty()) {
            try {
                double d = Double.parseDouble(value);
                if (this.inBounds(d)) {
                    this.value = d;
                } else {
                    LOGGER.warn("Failed to parse double {}. Was out of bounds {} - {}", new Object[]{value, this.minimumValue, this.maximumValue});
                }
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Failed to parse double {}", (Object)value);
            }
        }
    }

    public String method_20779() {
        return Double.toString(this.value);
    }

    public int method_20781() {
        return Double.compare(this.value, 0.0);
    }

    protected DoubleRule getThis() {
        return this;
    }

    protected DoubleRule copy() {
        return new DoubleRule((class_1928.class_4314<DoubleRule>)this.field_19417, this.value, this.minimumValue, this.maximumValue);
    }

    public void setValue(DoubleRule rule, class_10961 minecraftServer) {
        if (!this.inBounds(rule.value)) {
            throw new IllegalArgumentException(String.format("Could not set value to %s. Was out of bounds %s - %s", rule.value, this.minimumValue, this.maximumValue));
        }
        this.value = rule.value;
        this.method_20778(minecraftServer);
    }

    @Override
    public boolean validate(String value) {
        try {
            double d = Double.parseDouble(value);
            if (!this.inBounds(d)) {
                return false;
            }
            this.value = d;
            return true;
        }
        catch (NumberFormatException ignored) {
            return false;
        }
    }

    public double get() {
        return this.value;
    }

    private boolean inBounds(double value) {
        return value >= this.minimumValue && value <= this.maximumValue;
    }
}

