/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.gamerule.v1.rule;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleRegistry;
import net.minecraft.class_10961;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EnumRule<E extends Enum<E>>
extends class_1928.class_4315<EnumRule<E>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GameRuleRegistry.class);
    private final Class<E> classType;
    private final List<E> supportedValues;
    private E value;

    @Deprecated
    public EnumRule(class_1928.class_4314<EnumRule<E>> type, E value, E[] supportedValues) {
        this(type, value, Arrays.asList(supportedValues));
    }

    @Deprecated
    public EnumRule(class_1928.class_4314<EnumRule<E>> type, E value, Collection<E> supportedValues) {
        super(type);
        this.classType = ((Enum)value).getDeclaringClass();
        this.value = value;
        this.supportedValues = new ArrayList<E>(supportedValues);
        if (!this.supports(value)) {
            throw new IllegalArgumentException("Cannot set default value");
        }
    }

    protected void method_20776(CommandContext<class_2168> context, String name) {
    }

    protected void method_20777(String value) {
        try {
            E deserialized = Enum.valueOf(this.classType, value);
            if (!this.supports(deserialized)) {
                LOGGER.warn("Failed to parse rule of value {} for rule of type {}. Since the value {}, is unsupported.", new Object[]{value, this.classType, value});
            }
            this.set(deserialized, null);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Failed to parse rule of value {} for rule of type {}", (Object)value, this.classType);
        }
    }

    public String method_20779() {
        return ((Enum)this.value).name();
    }

    public int method_20781() {
        return ((Enum)this.value).ordinal();
    }

    protected EnumRule<E> getThis() {
        return this;
    }

    public Class<E> getEnumClass() {
        return this.classType;
    }

    public String toString() {
        return ((Enum)this.value).toString();
    }

    protected EnumRule<E> copy() {
        return new EnumRule<E>(this.field_19417, this.value, this.supportedValues);
    }

    public void setValue(EnumRule<E> rule, class_10961 minecraftServer) {
        if (!this.supports(rule.value)) {
            throw new IllegalArgumentException(String.format("Rule does not support value: %s", rule.value));
        }
        this.value = rule.value;
        this.method_20778(minecraftServer);
    }

    public E get() {
        return this.value;
    }

    public void cycle() {
        int index = this.supportedValues.indexOf(this.value);
        if (index < 0) {
            throw new IllegalArgumentException(String.format("Invalid value: %s", this.value));
        }
        this.set((Enum)this.supportedValues.get((index + 1) % this.supportedValues.size()), null);
    }

    public boolean supports(E value) {
        return this.supportedValues.contains(value);
    }

    public void set(E value, @Nullable class_10961 server) throws IllegalArgumentException {
        Preconditions.checkNotNull(value);
        if (!this.supports(value)) {
            throw new IllegalArgumentException("Tried to set an unsupported value: " + ((Enum)value).toString());
        }
        this.value = value;
        this.method_20778(server);
    }
}

