/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.gamerule;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Cancellable;
import com.llamalad7.mixinextras.sugar.Local;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.api.gamerule.v1.rule.DoubleRule;
import net.fabricmc.fabric.api.gamerule.v1.rule.EnumRule;
import net.fabricmc.fabric.impl.gamerule.rpc.FabricGameRuleType;
import net.fabricmc.fabric.impl.gamerule.rpc.FabricTypedRule;
import net.minecraft.class_11805;
import net.minecraft.class_11838;
import net.minecraft.class_11844;
import net.minecraft.class_11848;
import net.minecraft.class_11993;
import net.minecraft.class_1928;
import net.minecraft.class_3176;

@Mixin(class_11993.class)
public abstract class GameRuleManagementHandlerImplMixin {
	@Shadow
	@Final
	private class_3176 server;

	@Shadow
	public abstract class_11844.class_11846 toTypedRule(String name, class_1928.class_4315<?> gameRule);

	@Shadow
	@Final
	private class_11805 logger;

	@WrapOperation(method = "updateRule", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/GameRules$Rule;serialize()Ljava/lang/String;"))
	private String updateRule(class_1928.class_4315<?> rule, Operation<String> original, @Cancellable CallbackInfoReturnable<class_11844.class_11846> cir,
								@Local(argsOnly = true) class_11844.class_11847 untypedRule, @Local(argsOnly = true) class_11838 remote) {
		final String from = original.call(rule);

		try {
			if (rule instanceof DoubleRule doubleRule) {
				doubleRule.set(Double.parseDouble(untypedRule.comp_4723()), server);
				cir.setReturnValue(doUpdate(untypedRule, remote, rule, from));
			} else if (rule instanceof EnumRule<?> enumRule) {
				enumRule.set(untypedRule.comp_4723(), server);
				cir.setReturnValue(doUpdate(untypedRule, remote, rule, from));
			}
		} catch (IllegalArgumentException e) {
			throw new class_11848(e.getMessage());
		}

		return from;
	}

	@Inject(method = "toTypedRule", at = @At("HEAD"), cancellable = true)
	public void toTypedRule(String name, class_1928.class_4315<?> rule, CallbackInfoReturnable<class_11844.class_11846> cir) {
		if (rule instanceof DoubleRule) {
			cir.setReturnValue(FabricTypedRule.create(name, rule.method_20779(), FabricGameRuleType.DOUBLE));
		} else if (rule instanceof EnumRule<?>) {
			cir.setReturnValue(FabricTypedRule.create(name, rule.method_20779(), FabricGameRuleType.ENUM));
		}
	}

	@Unique
	private class_11844.class_11846 doUpdate(class_11844.class_11847 untypedRule, class_11838 remote, class_1928.class_4315<?> rule, String from) {
		// 3 lines copied from vanilla:
		class_11844.class_11846 typedRule = this.toTypedRule(untypedRule.comp_4722(), rule);
		this.logger.method_73655(remote, "Game rule '{}' updated from '{}' to '{}'", typedRule.comp_4719(), from, typedRule.comp_4720());
		this.server.method_74058(untypedRule.comp_4722(), rule);
		return typedRule;
	}
}
