/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.gamerule;

import static net.minecraft.class_2170.method_9247;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.fabricmc.fabric.mixin.gamerule.GameRuleCommandAccessor;
import net.minecraft.class_12279;
import net.minecraft.class_2168;
import net.minecraft.class_2561;

public final class EnumRuleCommand {
	public static <E extends Enum<E>> void register(LiteralArgumentBuilder<class_2168> literalArgumentBuilder, class_12279<E> enumRule) {
		String name = enumRule.toString();
		literalArgumentBuilder.then(method_9247(name).executes(context -> {
			// We can use the vanilla query method
			return GameRuleCommandAccessor.invokeExecuteQuery(context.getSource(), enumRule);
		}));

		// The LiteralRuleType handles the executeSet
		LiteralCommandNode<class_2168> ruleNode = method_9247(name).build();

		for (Enum<?> supportedValue : ((RuleTypeExtensions) (Object) enumRule).fabric_getSupportedEnumValues()) {
			ruleNode.addChild(method_9247(supportedValue.toString()).executes(context -> EnumRuleCommand.executeAndSetEnum(context, (E) supportedValue, enumRule)).build());
		}

		literalArgumentBuilder.then(ruleNode);
	}

	public static <E extends Enum<E>> int executeAndSetEnum(CommandContext<class_2168> context, E value, class_12279<E> enumRule) throws CommandSyntaxException {
		// Mostly copied from vanilla, but tweaked so we can use literals
		class_2168 serverCommandSource = context.getSource();

		try {
			serverCommandSource.method_9225().method_64395().method_76186(enumRule, value, serverCommandSource.method_9211());
		} catch (IllegalArgumentException e) {
			throw new SimpleCommandExceptionType(class_2561.method_43470(e.getMessage())).create();
		}

		serverCommandSource.method_9226(() -> class_2561.method_43469("commands.gamerule.set", enumRule.method_76144(), enumRule.method_76146(value)), true);
		return enumRule.method_76149(value);
	}
}
