/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.gametest;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.function.Consumer;

import javax.xml.parsers.ParserConfigurationException;

import org.slf4j.LoggerFactory;
import org.slf4j.Logger;
import net.minecraft.class_2338;
import net.minecraft.class_32;
import net.minecraft.class_3283;
import net.minecraft.class_4514;
import net.minecraft.class_4516;
import net.minecraft.class_4519;
import net.minecraft.class_4520;
import net.minecraft.class_4529;
import net.minecraft.class_5350;
import net.minecraft.class_5455;
import net.minecraft.class_5623;
import net.minecraft.class_6306;
import net.minecraft.class_6307;
import net.minecraft.server.MinecraftServer;
import net.fabricmc.fabric.api.gametest.v1.FabricGameTest;

public final class FabricGameTestHelper {
	public static final boolean ENABLED = System.getProperty("fabric-api.gametest") != null;

	private static final Logger LOGGER = LoggerFactory.getLogger(FabricGameTestHelper.class);

	private FabricGameTestHelper() {
	}

	public static void runHeadlessServer(class_32.class_5143 session, class_3283 resourcePackManager, class_5350 serverResourceManager, class_5455.class_5457 registryManager) {
		String reportPath = System.getProperty("fabric-api.gametest.report-file");

		if (reportPath != null) {
			try {
				class_5623.method_36100(new class_6307(new File(reportPath)));
			} catch (ParserConfigurationException e) {
				throw new RuntimeException(e);
			}
		}

		LOGGER.info("Starting test server");
		MinecraftServer server = class_6306.method_29740(thread -> {
			class_6306 testServer = new class_6306(thread, session, resourcePackManager, serverResourceManager, getBatches(), class_2338.field_10980, registryManager);
			return testServer;
		});
	}

	public static Consumer<class_4516> getTestMethodInvoker(Method method) {
		return testContext -> {
			Class<?> testClass = method.getDeclaringClass();

			Constructor<?> constructor;

			try {
				constructor = testClass.getConstructor();
			} catch (NoSuchMethodException e) {
				throw new RuntimeException("Test class (%s) provided by (%s) must have a public default or no args constructor".formatted(testClass.getSimpleName(), FabricGameTestModInitializer.getModIdForTestClass(testClass)));
			}

			Object testObject;

			try {
				testObject = constructor.newInstance();
			} catch (InvocationTargetException | InstantiationException | IllegalAccessException e) {
				throw new RuntimeException("Failed to create instance of test class (%s)".formatted(testClass.getCanonicalName()), e);
			}

			if (testObject instanceof FabricGameTest fabricGameTest) {
				fabricGameTest.invokeTestMethod(testContext, method);
			} else {
				invokeTestMethod(testContext, method, testObject);
			}
		};
	}

	public static void invokeTestMethod(class_4516 testContext, Method method, Object testObject) {
		try {
			method.invoke(testObject, testContext);
		} catch (IllegalAccessException e) {
			throw new RuntimeException("Failed to invoke test method (%s) in (%s) because %s".formatted(method.getName(), method.getDeclaringClass().getCanonicalName(), e.getMessage()), e);
		} catch (InvocationTargetException e) {
			if (e.getCause() instanceof RuntimeException runtimeException) {
				throw runtimeException;
			} else {
				throw new RuntimeException(e.getCause());
			}
		}
	}

	private static Collection<class_4514> getBatches() {
		return class_4520.method_22209(getTestFunctions());
	}

	private static Collection<class_4529> getTestFunctions() {
		return class_4519.method_22191();
	}
}
