/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.gametest;

import com.mojang.brigadier.arguments.ArgumentType;
import net.minecraft.class_155;
import net.minecraft.class_2314;
import net.minecraft.class_2316;
import net.minecraft.class_2319;
import net.minecraft.class_4526;
import net.minecraft.class_4530;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_2316.class)
public abstract class ArgumentTypesMixin {
	@Shadow
	public static <T extends ArgumentType<?>> void register(String id, Class<T> argClass, class_2314<T> serializer) {
		throw new AssertionError("Nope.");
	}

	@Inject(method = "register()V", at = @At("RETURN"))
	private static void register(CallbackInfo ci) {
		// Registered by vanilla when isDevelopment is enabled.
		if (!class_155.field_1125) {
			register("test_argument", class_4530.class, new class_2319<>(class_4530::method_22371));
			register("test_class", class_4526.class, new class_2319<>(class_4526::method_22370));
		}
	}
}
