/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.gametest;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3298;
import net.minecraft.class_3499;
import net.minecraft.class_4525;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_4525.class)
public abstract class StructureTestUtilMixin {
	private static final String GAMETEST_STRUCTURE_PATH = "gametest/structures/";

	// Replace the default test structure loading with something that works a bit better for mods.
	@Inject(at = @At("HEAD"), method = "createStructure(Ljava/lang/String;Lnet/minecraft/server/world/ServerWorld;)Lnet/minecraft/structure/Structure;", cancellable = true)
	private static void createStructure(String id, class_3218 world, CallbackInfoReturnable<class_3499> cir) {
		class_2960 baseId = new class_2960(id);
		class_2960 structureId = new class_2960(baseId.method_12836(), GAMETEST_STRUCTURE_PATH + baseId.method_12832() + ".snbt");

		try {
			class_3298 resource = world.method_8503().method_34864().method_14486(structureId).orElse(null);

			if (resource == null) {
				throw new RuntimeException("Unable to get resource: " + structureId);
			}

			String snbt;

			try (InputStream inputStream = resource.method_14482()) {
				snbt = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
			}

			class_2487 nbtCompound = class_2512.method_32260(snbt);
			class_3499 structure = world.method_14183().method_21891(nbtCompound);

			cir.setReturnValue(structure);
		} catch (IOException | CommandSyntaxException e) {
			throw new RuntimeException("Error while trying to load structure: " + structureId, e);
		}
	}
}
