/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.gametest;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.function.Consumer;
import javax.xml.parsers.ParserConfigurationException;
import net.fabricmc.fabric.api.gametest.v1.FabricGameTest;
import net.fabricmc.fabric.impl.gametest.FabricGameTestModInitializer;
import net.minecraft.class_2338;
import net.minecraft.class_32;
import net.minecraft.class_3283;
import net.minecraft.class_4514;
import net.minecraft.class_4516;
import net.minecraft.class_4519;
import net.minecraft.class_4520;
import net.minecraft.class_4529;
import net.minecraft.class_4531;
import net.minecraft.class_5350;
import net.minecraft.class_5455;
import net.minecraft.class_5623;
import net.minecraft.class_6306;
import net.minecraft.class_6307;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FabricGameTestHelper {
    public static final boolean ENABLED = System.getProperty("fabric-api.gametest") != null;
    private static final Logger LOGGER = LogManager.getLogger();

    private FabricGameTestHelper() {
    }

    public static void runHeadlessServer(class_32.class_5143 session, class_3283 resourcePackManager, class_5350 serverResourceManager, class_5455.class_5457 registryManager) {
        String reportPath = System.getProperty("fabric-api.gametest.report-file");
        if (reportPath != null) {
            try {
                class_5623.method_36100((class_4531)new class_6307(new File(reportPath)));
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        LOGGER.info("Starting test server");
        MinecraftServer server = class_6306.method_29740(thread -> {
            class_6306 testServer = new class_6306(thread, session, resourcePackManager, serverResourceManager, FabricGameTestHelper.getBatches(), class_2338.field_10980, registryManager);
            return testServer;
        });
    }

    public static Consumer<class_4516> getTestMethodInvoker(Method method) {
        return testContext -> {
            Object testObject;
            Constructor<?> constructor;
            Class<?> testClass = method.getDeclaringClass();
            try {
                constructor = testClass.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Test class (%s) provided by (%s) must have a public default or no args constructor".formatted(testClass.getSimpleName(), FabricGameTestModInitializer.getModIdForTestClass(testClass)));
            }
            try {
                testObject = constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException("Failed to create instance of test class (%s)".formatted(testClass.getCanonicalName()), e);
            }
            if (testObject instanceof FabricGameTest) {
                FabricGameTest fabricGameTest = (FabricGameTest)testObject;
                fabricGameTest.invokeTestMethod((class_4516)testContext, method);
            } else {
                FabricGameTestHelper.invokeTestMethod(testContext, method, testObject);
            }
        };
    }

    public static void invokeTestMethod(class_4516 testContext, Method method, Object testObject) {
        try {
            method.invoke(testObject, testContext);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Failed to invoke test method (%s) in (%s)".formatted(method.getName(), method.getDeclaringClass().getCanonicalName()), e);
        }
    }

    private static Collection<class_4514> getBatches() {
        return class_4520.method_22209(FabricGameTestHelper.getTestFunctions());
    }

    private static Collection<class_4529> getTestFunctions() {
        return class_4519.method_22191();
    }
}

