/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.gametest;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3298;
import net.minecraft.class_3499;
import net.minecraft.class_4525;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_4525.class})
public abstract class StructureTestUtilMixin {
    private static final String GAMETEST_STRUCTURE_PATH = "gametest/structures/";

    @Inject(at={@At(value="HEAD")}, method={"createStructureTemplate(Ljava/lang/String;Lnet/minecraft/server/world/ServerWorld;)Lnet/minecraft/structure/StructureTemplate;"}, cancellable=true)
    private static void createStructure(String id, class_3218 world, CallbackInfoReturnable<class_3499> cir) {
        class_2960 baseId = new class_2960(id);
        class_2960 structureId = new class_2960(baseId.method_12836(), GAMETEST_STRUCTURE_PATH + baseId.method_12832() + ".snbt");
        try {
            String snbt;
            class_3298 resource = world.method_8503().method_34864().method_14486(structureId).orElse(null);
            if (resource == null) {
                throw new RuntimeException("Unable to get resource: " + structureId);
            }
            try (InputStream inputStream = resource.method_14482();){
                snbt = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
            }
            class_2487 nbtCompound = class_2512.method_32260((String)snbt);
            class_3499 structure = world.method_14183().method_21891(nbtCompound);
            cir.setReturnValue((Object)structure);
        }
        catch (CommandSyntaxException | IOException e) {
            throw new RuntimeException("Error while trying to load structure: " + structureId, e);
        }
    }
}

