/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.gametest;

import java.io.File;
import java.util.Optional;

import javax.xml.parsers.ParserConfigurationException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.minecraft.class_32;
import net.minecraft.class_3283;
import net.minecraft.class_5623;
import net.minecraft.class_6306;
import net.minecraft.class_7654;
import net.minecraft.server.MinecraftServer;

public final class FabricGameTestRunner {
	public static final boolean ENABLED = System.getProperty(GameTestSystemProperties.ENABLED) != null;

	private static final Logger LOGGER = LoggerFactory.getLogger(FabricGameTestRunner.class);
	private static final String GAMETEST_STRUCTURE_PATH = "gametest/structure";

	public static final class_7654 GAMETEST_STRUCTURE_FINDER = new class_7654(GAMETEST_STRUCTURE_PATH, ".snbt");

	private FabricGameTestRunner() {
	}

	public static void runHeadlessServer(class_32.class_5143 session, class_3283 resourcePackManager) {
		String reportPath = System.getProperty(GameTestSystemProperties.REPORT_FILE);

		if (reportPath != null) {
			try {
				class_5623.method_36100(new SavingXmlReportingTestCompletionListener(new File(reportPath)));
			} catch (ParserConfigurationException e) {
				throw new RuntimeException(e);
			}
		}

		LOGGER.info("Starting test server");

		Optional<String> filter = Optional.ofNullable(System.getProperty(GameTestSystemProperties.FILTER));
		boolean verify = Boolean.getBoolean(GameTestSystemProperties.VERIFY);
		MinecraftServer.method_29740((thread) -> class_6306.method_40378(thread, session, resourcePackManager, filter, verify));
	}
}
