/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.item.client;

import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_636;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(class_636.class)
public class MultiPlayerGameModeMixin {
	@Shadow
	@Final
	private class_310 minecraft;
	@Shadow
	private class_2338 destroyBlockPos;
	@Shadow
	private class_1799 destroyingItem;

	/**
	 * Allows a FabricItem to continue block breaking progress even if the count or nbt changed.
	 * For this, we inject after vanilla decided that the stack was "not unchanged", and we set if back to "unchanged"
	 * if the item wishes to continue mining.
	 */
	@Redirect(
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/world/item/ItemStack;isSameItemSameComponents(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)Z"
			),
			method = "sameDestroyTarget"
	)
	private boolean fabricItemContinueBlockBreakingInject(class_1799 stack, class_1799 otherStack) {
		boolean stackUnchanged = class_1799.method_31577(stack, this.destroyingItem);

		if (!stackUnchanged) {
			// The stack changed and vanilla is about to cancel block breaking progress. Check if the item wants to continue block breaking instead.
			class_1799 oldStack = this.destroyingItem;
			class_1799 newStack = this.minecraft.field_1724.method_6047();

			if (oldStack.method_31574(newStack.method_7909()) && oldStack.method_7909().allowContinuingBlockBreaking(this.minecraft.field_1724, oldStack, newStack)) {
				stackUnchanged = true;
			}
		}

		return stackUnchanged;
	}
}
