/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.item;

import java.util.List;
import net.minecraft.class_1887;
import net.minecraft.class_6885;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;

@Mixin(class_1887.class_9700.class)
public interface EnchantmentBuilderAccessor {
	@Accessor("definition")
	class_1887.class_9427 getDefinition();

	@Accessor("exclusiveSet")
	class_6885<class_1887> getExclusiveSet();

	@Accessor("effectMapBuilder")
	class_9323.class_9324 getEffectMap();

	@Invoker("getEffectsList")
	<E> List<E> invokeGetEffectsList(class_9331<List<E>> type);
}
