/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.itemgroup.v1;

import java.util.Objects;
import net.fabricmc.fabric.impl.itemgroup.ItemGroupHelper;
import net.minecraft.class_1761;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7706;

/**
 * Extend this abstract class to create a new {@link class_1761} for a mod.
 *
 * <p>Each new instance of this class is automatically appended to {@link class_7706#field_40207}.
 *
 * <p>Example:
 * <pre>{@code
 * public static final ItemGroup ITEM_GROUP = new FabricItemGroup(new Identifier("modid", "test_group")) {
 *    @Override
 *    public ItemStack createIcon() {
 *       return new ItemStack(Items.DIAMOND);
 *    }
 *
 *    @Override
 *    protected void addItems(FeatureSet enabledFeatures, Entries entries) {
 *       entries.add(TEST_ITEM);
 *     }
 * };
 * }</pre>
 */
public abstract class FabricItemGroup extends class_1761 implements IdentifiableItemGroup {
	private final class_2960 identifier;

	public FabricItemGroup(class_2960 identifier) {
		super(-1, getText(Objects.requireNonNull(identifier, "identifier")));
		this.identifier = identifier;
		ItemGroupHelper.appendItemGroup(this);
	}

	private static class_2561 getText(class_2960 identifier) {
		return class_2561.method_43471("itemGroup.%s.%s".formatted(identifier.method_12836(), identifier.method_12832()));
	}

	@Override
	public final class_2960 getId() {
		return identifier;
	}
}
