/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.itemgroup;

import net.minecraft.class_1761;
import net.minecraft.class_7706;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_7706.class)
abstract class ItemGroupsMixin {
	@Inject(method = "asArray", at = @At("HEAD"))
	private static void asArray(class_1761[] groups, CallbackInfoReturnable<class_1761[]> cir) {
		// Ensure that all item groups have a nonnull id.
		for (class_1761 group : groups) {
			if (group.getId() == null) {
				throw new NullPointerException("Item group %s has a null id".formatted(group.getClass().getName()));
			}
		}
	}
}
