/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.itemgroup;

import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.ApiStatus;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.mixin.itemgroup.ItemGroupAccessor;
import net.fabricmc.fabric.mixin.itemgroup.ItemGroupsAccessor;
import net.minecraft.class_1761;
import net.minecraft.class_7706;

@ApiStatus.Internal
public final class ItemGroupHelper {
	private ItemGroupHelper() {
	}

	public static void appendItemGroup(FabricItemGroup itemGroup) {
		for (class_1761 existingGroup : class_7706.field_40207) {
			if (existingGroup.getId().equals(itemGroup.getId())) {
				throw new IllegalStateException("Duplicate item group: " + itemGroup.getId());
			}
		}

		final int index = class_7706.field_40207.length;
		final class_1761[] itemGroups = ArrayUtils.add(class_7706.field_40207, itemGroup);

		((ItemGroupAccessor) itemGroup).setIndex(index);
		ItemGroupsAccessor.setGroups(ItemGroupsAccessor.invokeAsArray(itemGroups));
	}
}
