/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.itemgroup.client;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.itemgroup.CreativeGuiExtensions;
import net.fabricmc.fabric.impl.itemgroup.FabricCreativeGuiComponents;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1761;
import net.minecraft.class_2561;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_481;
import net.minecraft.class_485;
import net.minecraft.class_7706;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_481.class})
public abstract class CreativeInventoryScreenMixin<T extends class_1703>
extends class_485<T>
implements CreativeGuiExtensions {
    private static int fabric_currentPage = 0;

    public CreativeInventoryScreenMixin(T screenHandler, class_1661 playerInventory, class_2561 text) {
        super(screenHandler, playerInventory, text);
    }

    @Shadow
    protected abstract void method_2466(class_1761 var1);

    @Shadow
    public abstract int method_2469();

    private int fabric_getPageOffset(int page) {
        return switch (page) {
            case 0 -> 0;
            case 1 -> 12;
            default -> 12 + (12 - FabricCreativeGuiComponents.COMMON_GROUPS.size()) * (page - 1);
        };
    }

    private int fabric_getOffsetPage(int offset) {
        if (offset < 12) {
            return 0;
        }
        return 1 + (offset - 12) / (12 - FabricCreativeGuiComponents.COMMON_GROUPS.size());
    }

    @Override
    public void fabric_nextPage() {
        if (this.fabric_getPageOffset(fabric_currentPage + 1) >= class_7706.field_40207.length) {
            return;
        }
        ++fabric_currentPage;
        this.fabric_updateSelection();
    }

    @Override
    public void fabric_previousPage() {
        if (fabric_currentPage == 0) {
            return;
        }
        --fabric_currentPage;
        this.fabric_updateSelection();
    }

    @Override
    public boolean fabric_isButtonVisible(FabricCreativeGuiComponents.Type type) {
        return class_7706.field_40207.length > 12;
    }

    @Override
    public boolean fabric_isButtonEnabled(FabricCreativeGuiComponents.Type type) {
        if (type == FabricCreativeGuiComponents.Type.NEXT) {
            return this.fabric_getPageOffset(fabric_currentPage + 1) < class_7706.field_40207.length;
        }
        if (type == FabricCreativeGuiComponents.Type.PREVIOUS) {
            return fabric_currentPage != 0;
        }
        return false;
    }

    private void fabric_updateSelection() {
        int minPos = this.fabric_getPageOffset(fabric_currentPage);
        int maxPos = this.fabric_getPageOffset(fabric_currentPage + 1) - 1;
        int curPos = this.method_2469();
        if (curPos < minPos || curPos > maxPos) {
            this.method_2466(class_7706.field_40207[this.fabric_getPageOffset(fabric_currentPage)]);
        }
    }

    @Inject(method={"init"}, at={@At(value="RETURN")})
    private void init(CallbackInfo info) {
        this.fabric_updateSelection();
        int xpos = this.field_2776 + 116;
        int ypos = this.field_2800 - 10;
        this.method_37063((class_364)new FabricCreativeGuiComponents.ItemGroupButtonWidget(xpos + 11, ypos, FabricCreativeGuiComponents.Type.NEXT, this));
        this.method_37063((class_364)new FabricCreativeGuiComponents.ItemGroupButtonWidget(xpos, ypos, FabricCreativeGuiComponents.Type.PREVIOUS, this));
    }

    @Inject(method={"setSelectedTab"}, at={@At(value="HEAD")}, cancellable=true)
    private void setSelectedTab(class_1761 itemGroup, CallbackInfo info) {
        if (!this.fabric_isGroupVisible(itemGroup)) {
            info.cancel();
        }
    }

    @Inject(method={"renderTabTooltipIfHovered"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderTabTooltipIfHovered(class_4587 matrixStack, class_1761 itemGroup, int mx, int my, CallbackInfoReturnable<Boolean> info) {
        if (!this.fabric_isGroupVisible(itemGroup)) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"isClickInTab"}, at={@At(value="HEAD")}, cancellable=true)
    private void isClickInTab(class_1761 itemGroup, double mx, double my, CallbackInfoReturnable<Boolean> info) {
        if (!this.fabric_isGroupVisible(itemGroup)) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"renderTabIcon"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderTabIcon(class_4587 matrixStack, class_1761 itemGroup, CallbackInfo info) {
        if (!this.fabric_isGroupVisible(itemGroup)) {
            info.cancel();
        }
    }

    private boolean fabric_isGroupVisible(class_1761 itemGroup) {
        if (FabricCreativeGuiComponents.COMMON_GROUPS.contains(itemGroup)) {
            return true;
        }
        return fabric_currentPage == this.fabric_getOffsetPage(itemGroup.method_7741());
    }

    @Override
    public int fabric_currentPage() {
        return fabric_currentPage;
    }
}

