/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.itemgroup;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.impl.itemgroup.FabricItemGroup;
import net.minecraft.class_1761;
import net.minecraft.class_7706;

@Mixin(class_7706.class)
public class ItemGroupsMixin {
	@Shadow
	@Final
	private static class_1761 BUILDING_BLOCKS;
	@Shadow
	@Final
	private static class_1761 COLORED_BLOCKS;
	@Shadow
	@Final
	private static class_1761 NATURAL;
	@Shadow
	@Final
	private static class_1761 FUNCTIONAL;
	@Shadow
	@Final
	private static class_1761 REDSTONE;
	@Shadow
	@Final
	private static class_1761 HOTBAR;
	@Shadow
	@Final
	private static class_1761 SEARCH;
	@Shadow
	@Final
	private static class_1761 TOOLS;
	@Shadow
	@Final
	private static class_1761 COMBAT;
	@Shadow
	@Final
	private static class_1761 FOOD_AND_DRINK;
	@Shadow
	@Final
	private static class_1761 INGREDIENTS;
	@Shadow
	@Final
	private static class_1761 SPAWN_EGGS;
	@Shadow
	@Final
	private static class_1761 OPERATOR;
	@Shadow
	@Final
	private static class_1761 INVENTORY;

	@Unique
	private static final int TABS_PER_PAGE = 10;

	@Inject(method = "collect", at = @At("HEAD"), cancellable = true)
	private static void collect(class_1761[] groups, CallbackInfoReturnable<List<class_1761>> cir) {
		final List<class_1761> vanillaGroups = List.of(BUILDING_BLOCKS, COLORED_BLOCKS, NATURAL, FUNCTIONAL, REDSTONE, HOTBAR, SEARCH, TOOLS, COMBAT, FOOD_AND_DRINK, INGREDIENTS, SPAWN_EGGS, OPERATOR, INVENTORY);

		for (class_1761 vanillaGroup : vanillaGroups) {
			Objects.requireNonNull(vanillaGroup);
		}

		int count = 0;

		for (class_1761 itemGroup : groups) {
			final FabricItemGroup fabricItemGroup = (FabricItemGroup) itemGroup;

			if (vanillaGroups.contains(itemGroup)) {
				// Vanilla group goes on the first page.
				fabricItemGroup.setPage(0);
				continue;
			}

			final ItemGroupAccessor itemGroupAccessor = (ItemGroupAccessor) itemGroup;
			fabricItemGroup.setPage((count / TABS_PER_PAGE) + 1);
			int pageIndex = count % TABS_PER_PAGE;
			class_1761.class_7915 row = pageIndex < (TABS_PER_PAGE / 2) ? class_1761.class_7915.field_41049 : class_1761.class_7915.field_41050;
			itemGroupAccessor.setRow(row);
			itemGroupAccessor.setColumn(row == class_1761.class_7915.field_41049 ? pageIndex % TABS_PER_PAGE : (pageIndex - TABS_PER_PAGE / 2) % (TABS_PER_PAGE));

			count++;
		}

		// Overlapping group detection logic, with support for pages.
		record ItemGroupPosition(class_1761.class_7915 row, int column, int page) { }
		var map = new HashMap<ItemGroupPosition, String>();

		for (class_1761 itemGroup : groups) {
			final FabricItemGroup fabricItemGroup = (FabricItemGroup) itemGroup;
			final String displayName = itemGroup.method_7737().getString();
			final var position = new ItemGroupPosition(itemGroup.method_47309(), itemGroup.method_7743(), fabricItemGroup.getPage());
			final String existingName = map.put(position, displayName);

			if (existingName != null) {
				throw new IllegalArgumentException("Duplicate position: (%s) for item groups %s vs %s".formatted(position, displayName, existingName));
			}
		}

		cir.setReturnValue(List.of(groups));
	}
}
