/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.itemgroup;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.fabricmc.fabric.api.itemgroup.v1.IdentifiableItemGroup;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.impl.itemgroup.FabricItemGroup;
import net.fabricmc.fabric.impl.itemgroup.ItemGroupEventsImpl;
import net.fabricmc.fabric.impl.itemgroup.MinecraftItemGroups;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_7706;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1761.class})
abstract class ItemGroupMixin
implements IdentifiableItemGroup,
FabricItemGroup {
    @Shadow
    private Collection<class_1799> field_40859;
    @Shadow
    private Set<class_1799> field_40860;
    @Unique
    private int fabric_page = -1;
    @Unique
    private class_2960 identifier;
    @Unique
    @Nullable
    private UUID fabric_fallbackUUID;

    ItemGroupMixin() {
    }

    @Inject(method={"updateEntries"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemGroup;reloadSearchProvider()V")})
    public void getStacks(class_1761.class_8128 context, CallbackInfo ci) {
        class_1761 self = (class_1761)this;
        if (self.method_7752() && self != class_7706.field_41063) {
            return;
        }
        Objects.requireNonNull(this.field_40859, "displayStacks");
        Objects.requireNonNull(this.field_40860, "searchTabStacks");
        LinkedList<class_1799> mutableDisplayStacks = new LinkedList<class_1799>(this.field_40859);
        LinkedList<class_1799> mutableSearchTabStacks = new LinkedList<class_1799>(this.field_40860);
        FabricItemGroupEntries entries = new FabricItemGroupEntries(context, mutableDisplayStacks, mutableSearchTabStacks);
        Event<ItemGroupEvents.ModifyEntries> modifyEntriesEvent = ItemGroupEventsImpl.getModifyEntriesEvent(this.getId());
        if (modifyEntriesEvent != null) {
            ((ItemGroupEvents.ModifyEntries)modifyEntriesEvent.invoker()).modifyEntries(entries);
        }
        if (self != class_7706.field_41063 || context.comp_1252()) {
            ((ItemGroupEvents.ModifyEntriesAll)ItemGroupEvents.MODIFY_ENTRIES_ALL.invoker()).modifyEntries(self, entries);
        }
        this.field_40859.clear();
        this.field_40859.addAll(mutableDisplayStacks);
        this.field_40860.clear();
        this.field_40860.addAll(mutableSearchTabStacks);
    }

    @Override
    public class_2960 getId() {
        if (this.identifier != null) {
            return this.identifier;
        }
        class_2960 vanillaId = MinecraftItemGroups.GROUP_ID_MAP.get((class_1761)this);
        if (vanillaId != null) {
            return vanillaId;
        }
        if (this.identifier == null) {
            this.setId(new class_2960("minecraft", "unidentified_" + UUID.randomUUID()));
        }
        return this.identifier;
    }

    @Override
    public int getPage() {
        if (this.fabric_page < 0) {
            throw new IllegalStateException("Item group has no page");
        }
        return this.fabric_page;
    }

    @Override
    public void setPage(int page) {
        this.fabric_page = page;
    }

    @Override
    public void setId(class_2960 identifier) {
        if (this.identifier != null) {
            throw new IllegalStateException("Cannot set id to (%s) as item group already has id (%s)".formatted(identifier, this.identifier));
        }
        this.identifier = identifier;
    }
}

