/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.itemgroup;

import static net.minecraft.class_7706.field_40195;
import static net.minecraft.class_7706.field_41059;
import static net.minecraft.class_7706.field_40202;
import static net.minecraft.class_7706.field_41061;
import static net.minecraft.class_7706.field_40197;
import static net.minecraft.class_7706.field_40199;
import static net.minecraft.class_7706.field_41062;
import static net.minecraft.class_7706.field_40206;
import static net.minecraft.class_7706.field_40743;
import static net.minecraft.class_7706.field_41063;
import static net.minecraft.class_7706.field_40198;
import static net.minecraft.class_7706.field_40200;
import static net.minecraft.class_7706.field_40205;
import static net.minecraft.class_7706.field_41060;

import java.util.HashMap;
import java.util.List;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.impl.itemgroup.FabricItemGroup;
import net.minecraft.class_1761;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;

@Mixin(class_7706.class)
public class ItemGroupsMixin {
	@Unique
	private static final int TABS_PER_PAGE = 10;

	@Inject(method = "collect", at = @At("HEAD"), cancellable = true)
	private static void collect(CallbackInfo ci) {
		final List<class_5321<class_1761>> vanillaGroups = List.of(field_40195, field_41059, field_40743, field_40197, field_40198, field_40199, field_40200, field_41060, field_40202, field_41061, field_41062, field_40205, field_41063, field_40206);

		int count = 0;

		for (class_5321<class_1761> registryKey : class_7923.field_44687.method_42021()) {
			final class_1761 itemGroup = class_7923.field_44687.method_31140(registryKey);
			final FabricItemGroup fabricItemGroup = (FabricItemGroup) itemGroup;

			if (vanillaGroups.contains(registryKey)) {
				// Vanilla group goes on the first page.
				fabricItemGroup.setPage(0);
				continue;
			}

			final ItemGroupAccessor itemGroupAccessor = (ItemGroupAccessor) itemGroup;
			fabricItemGroup.setPage((count / TABS_PER_PAGE) + 1);
			int pageIndex = count % TABS_PER_PAGE;
			class_1761.class_7915 row = pageIndex < (TABS_PER_PAGE / 2) ? class_1761.class_7915.field_41049 : class_1761.class_7915.field_41050;
			itemGroupAccessor.setRow(row);
			itemGroupAccessor.setColumn(row == class_1761.class_7915.field_41049 ? pageIndex % TABS_PER_PAGE : (pageIndex - TABS_PER_PAGE / 2) % (TABS_PER_PAGE));

			count++;
		}

		// Overlapping group detection logic, with support for pages.
		record ItemGroupPosition(class_1761.class_7915 row, int column, int page) { }
		var map = new HashMap<ItemGroupPosition, String>();

		for (class_5321<class_1761> registryKey : class_7923.field_44687.method_42021()) {
			final class_1761 itemGroup = class_7923.field_44687.method_31140(registryKey);
			final FabricItemGroup fabricItemGroup = (FabricItemGroup) itemGroup;
			final String displayName = itemGroup.method_7737().getString();
			final var position = new ItemGroupPosition(itemGroup.method_47309(), itemGroup.method_7743(), fabricItemGroup.getPage());
			final String existingName = map.put(position, displayName);

			if (existingName != null) {
				throw new IllegalArgumentException("Duplicate position: (%s) for item groups %s vs %s".formatted(position, displayName, existingName));
			}
		}

		ci.cancel();
	}
}
