/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.itemgroup;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.impl.itemgroup.FabricItemGroupImpl;
import net.fabricmc.fabric.impl.itemgroup.ItemGroupEventsImpl;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CreativeModeTab.class})
abstract class CreativeModeTabMixin
implements FabricItemGroupImpl {
    @Shadow
    private Collection<ItemStack> displayItems;
    @Shadow
    private Set<ItemStack> displayItemsSearchTab;
    @Unique
    private int page = -1;

    CreativeModeTabMixin() {
    }

    @Inject(method={"buildContents"}, at={@At(value="TAIL")})
    public void getStacks(CreativeModeTab.ItemDisplayParameters context, CallbackInfo ci) {
        CreativeModeTab self = (CreativeModeTab)this;
        ResourceKey registryKey = (ResourceKey)BuiltInRegistries.CREATIVE_MODE_TAB.getResourceKey((Object)self).orElseThrow(() -> new IllegalStateException("Unregistered item group : " + String.valueOf(self)));
        if (self.isAlignedRight() && registryKey != CreativeModeTabs.OP_BLOCKS) {
            return;
        }
        Objects.requireNonNull(this.displayItems, "displayStacks");
        Objects.requireNonNull(this.displayItemsSearchTab, "searchTabStacks");
        LinkedList<ItemStack> mutableDisplayStacks = new LinkedList<ItemStack>(this.displayItems);
        LinkedList<ItemStack> mutableSearchTabStacks = new LinkedList<ItemStack>(this.displayItemsSearchTab);
        FabricItemGroupEntries entries = new FabricItemGroupEntries(context, mutableDisplayStacks, mutableSearchTabStacks);
        if (registryKey != CreativeModeTabs.OP_BLOCKS || context.hasPermissions()) {
            Event<ItemGroupEvents.ModifyEntries> modifyEntriesEvent = ItemGroupEventsImpl.getModifyEntriesEvent((ResourceKey<CreativeModeTab>)registryKey);
            if (modifyEntriesEvent != null) {
                ((ItemGroupEvents.ModifyEntries)modifyEntriesEvent.invoker()).modifyEntries(entries);
            }
            ((ItemGroupEvents.ModifyEntriesAll)ItemGroupEvents.MODIFY_ENTRIES_ALL.invoker()).modifyEntries(self, entries);
        }
        this.displayItems.clear();
        this.displayItems.addAll(mutableDisplayStacks);
        this.displayItemsSearchTab.clear();
        this.displayItemsSearchTab.addAll(mutableSearchTabStacks);
    }

    @Override
    public int fabric_getPage() {
        if (this.page < 0) {
            throw new IllegalStateException("Item group has no page");
        }
        return this.page;
    }

    @Override
    public void fabric_setPage(int page) {
        this.page = page;
    }
}

