/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.itemgroup;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import org.jspecify.annotations.Nullable;

public class ItemGroupEventsImpl {
    private static final Map<ResourceKey<CreativeModeTab>, Event<ItemGroupEvents.ModifyEntries>> ITEM_GROUP_EVENT_MAP = new HashMap<ResourceKey<CreativeModeTab>, Event<ItemGroupEvents.ModifyEntries>>();

    public static Event<ItemGroupEvents.ModifyEntries> getOrCreateModifyEntriesEvent(ResourceKey<CreativeModeTab> registryKey) {
        return ITEM_GROUP_EVENT_MAP.computeIfAbsent(registryKey, g -> ItemGroupEventsImpl.createModifyEvent());
    }

    public static @Nullable Event<ItemGroupEvents.ModifyEntries> getModifyEntriesEvent(ResourceKey<CreativeModeTab> registryKey) {
        return ITEM_GROUP_EVENT_MAP.get(registryKey);
    }

    private static Event<ItemGroupEvents.ModifyEntries> createModifyEvent() {
        return EventFactory.createArrayBacked(ItemGroupEvents.ModifyEntries.class, callbacks -> entries -> {
            for (ItemGroupEvents.ModifyEntries callback : callbacks) {
                callback.modifyEntries(entries);
            }
        });
    }
}

