/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.item.group;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1761;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_481;
import com.mojang.blaze3d.systems.RenderSystem;

public class FabricCreativeGuiComponents {
	private static final class_2960 BUTTON_TEX = new class_2960("fabric", "textures/gui/creative_buttons.png");
	public static final Set<class_1761> COMMON_GROUPS = new HashSet<>();

	static {
		COMMON_GROUPS.add(class_1761.field_7915);
		COMMON_GROUPS.add(class_1761.field_7918);
		COMMON_GROUPS.add(class_1761.field_7925);
	}

	public static class ItemGroupButtonWidget extends class_4185 {
		CreativeGuiExtensions extensions;
		class_481 gui;
		Type type;

		public ItemGroupButtonWidget(int x, int y, Type type, CreativeGuiExtensions extensions) {
			super(x, y, 10, 11, type.text, (bw) -> type.clickConsumer.accept(extensions));
			this.extensions = extensions;
			this.type = type;
			this.gui = (class_481) extensions;
		}

		@Override
		public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float float_1) {
			this.field_22764 = extensions.fabric_isButtonVisible(type);
			this.field_22763 = extensions.fabric_isButtonEnabled(type);

			if (this.field_22764) {
				class_310 minecraftClient = class_310.method_1551();
				minecraftClient.method_1531().method_22813(BUTTON_TEX);
				RenderSystem.disableLighting();
				RenderSystem.color4f(1F, 1F, 1F, 1F);
				this.method_25302(matrixStack, this.field_22760, this.field_22761, (type == Type.NEXT ? 12 : 0), (field_22763 ? 0 : 12), 12, 12);

				if (mouseX >= this.field_22760 && mouseY >= this.field_22761 && mouseX < this.field_22760 + this.field_22758 && mouseY < this.field_22761 + this.field_22759) {
					gui.method_25424(matrixStack, new class_2588("fabric.gui.creativeTabPage", extensions.fabric_currentPage() + 1, ((class_1761.field_7921.length - 12) / 9) + 2), mouseX, mouseY);
				}
			}
		}
	}

	public enum Type {
		NEXT(new class_2585(">"), CreativeGuiExtensions::fabric_nextPage),
		PREVIOUS(new class_2585("<"), CreativeGuiExtensions::fabric_previousPage);

		class_2561 text;
		Consumer<CreativeGuiExtensions> clickConsumer;

		Type(class_2561 text, Consumer<CreativeGuiExtensions> clickConsumer) {
			this.text = text;
			this.clickConsumer = clickConsumer;
		}
	}
}
