/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.client.itemgroup;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.impl.itemgroup.ItemGroupExtensions;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2960;

public final class FabricItemGroupBuilder {
	private class_2960 identifier;
	private Supplier<class_1799> stackSupplier = () -> class_1799.field_8037;
	private Consumer<List<class_1799>> stacksForDisplay;

	private FabricItemGroupBuilder(class_2960 identifier) {
		this.identifier = identifier;
	}

	/**
	 * Create a new Item Group Builder.
	 *
	 * @param identifier the id will become the name of the ItemGroup and will be used for the translation key
	 * @return a FabricItemGroupBuilder
	 */
	public static FabricItemGroupBuilder create(class_2960 identifier) {
		return new FabricItemGroupBuilder(identifier);
	}

	/**
	 * This is used to add an icon to to the item group.
	 *
	 * @param stackSupplier the supplier should return the item stack that you wish to show on the tab
	 * @return a reference to the FabricItemGroupBuilder
	 */
	public FabricItemGroupBuilder icon(Supplier<class_1799> stackSupplier) {
		this.stackSupplier = stackSupplier;
		return this;
	}

	/**
	 * This allows for a custom list of items to be displayed in a tab, this enabled tabs to be created with a custom set of items.
	 *
	 * @param appender Add ItemStack's to this list to show in the ItemGroup
	 * @return a reference to the FabricItemGroupBuilder
	 * @deprecated use {@link FabricItemGroupBuilder#appendItems(Consumer)}
	 */
	@Deprecated
	public FabricItemGroupBuilder stacksForDisplay(Consumer<List<class_1799>> appender) {
		return appendItems(appender);
	}

	/**
	 * This allows for a custom list of items to be displayed in a tab, this enabled tabs to be created with a custom set of items.
	 *
	 * @param stacksForDisplay Add ItemStack's to this list to show in the ItemGroup
	 * @return a reference to the FabricItemGroupBuilder
	 */
	public FabricItemGroupBuilder appendItems(Consumer<List<class_1799>> stacksForDisplay) {
		this.stacksForDisplay = stacksForDisplay;
		return this;
	}

	/**
	 * This is a single method that makes creating an ItemGroup with an icon one call.
	 *
	 * @param identifier    the id will become the name of the ItemGroup and will be used for the translation key
	 * @param stackSupplier the supplier should return the item stack that you wish to show on the tab
	 * @return An instance of the built ItemGroup
	 */
	public static class_1761 build(class_2960 identifier, Supplier<class_1799> stackSupplier) {
		return new FabricItemGroupBuilder(identifier).icon(stackSupplier).build();
	}

	/**
	 * Create an instance of the ItemGroup.
	 *
	 * @return An instance of the built ItemGroup
	 */
	public class_1761 build() {
		((ItemGroupExtensions) class_1761.field_7931).fabric_expandArray();
		return new class_1761(class_1761.field_7921.length - 1, String.format("%s.%s", identifier.method_12836(), identifier.method_12832())) {
			@Override
			public class_1799 method_7750() {
				return stackSupplier.get();
			}

			@Override
			public void method_7738(class_2371<class_1799> stacks) {
				if (stacksForDisplay != null) {
					stacksForDisplay.accept(stacks);
					return;
				}

				super.method_7738(stacks);
			}
		};
	}
}
