/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.keybinding;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;

public final class KeyBindingRegistryImpl {
    private static final List<KeyMapping> MODDED_KEY_BINDINGS = new ReferenceArrayList();

    private KeyBindingRegistryImpl() {
    }

    public static KeyMapping registerKeyBinding(KeyMapping binding) {
        if (Minecraft.getInstance().options != null) {
            throw new IllegalStateException("GameOptions has already been initialised");
        }
        for (KeyMapping existingKeyBindings : MODDED_KEY_BINDINGS) {
            if (existingKeyBindings == binding) {
                throw new IllegalArgumentException("Attempted to register a key binding twice: " + binding.getName());
            }
            if (!existingKeyBindings.getName().equals(binding.getName())) continue;
            throw new IllegalArgumentException("Attempted to register two key bindings with equal ID: " + binding.getName() + "!");
        }
        MODDED_KEY_BINDINGS.add(binding);
        return binding;
    }

    public static KeyMapping[] process(KeyMapping[] keysAll) {
        ArrayList newKeysAll = Lists.newArrayList((Object[])keysAll);
        newKeysAll.removeAll(MODDED_KEY_BINDINGS);
        newKeysAll.addAll(MODDED_KEY_BINDINGS);
        return newKeysAll.toArray(new KeyMapping[0]);
    }
}

