/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.event.lifecycle;

import java.util.Iterator;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerBlockEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin {
    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;setFavicon(Lnet/minecraft/server/ServerMetadata;)V", ordinal=0)}, method={"method_29741"})
    private void afterSetupServer(CallbackInfo info) {
        ((ServerLifecycleEvents.ServerStarted)ServerLifecycleEvents.SERVER_STARTED.invoker()).onServerStarted((MinecraftServer)this);
    }

    @Inject(at={@At(value="HEAD")}, method={"shutdown"})
    private void beforeShutdownServer(CallbackInfo info) {
        ((ServerLifecycleEvents.ServerStopping)ServerLifecycleEvents.SERVER_STOPPING.invoker()).onServerStopping((MinecraftServer)this);
    }

    @Inject(at={@At(value="TAIL")}, method={"shutdown"})
    private void afterShutdownServer(CallbackInfo info) {
        ((ServerLifecycleEvents.ServerStopped)ServerLifecycleEvents.SERVER_STOPPED.invoker()).onServerStopped((MinecraftServer)this);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;tickWorlds(Ljava/util/function/BooleanSupplier;)V")}, method={"tick"})
    private void onStartTick(BooleanSupplier shouldKeepTicking, CallbackInfo ci) {
        ((ServerTickEvents.StartTick)ServerTickEvents.START_SERVER_TICK.invoker()).onStartTick((MinecraftServer)this);
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void onEndTick(BooleanSupplier shouldKeepTicking, CallbackInfo info) {
        ((ServerTickEvents.EndTick)ServerTickEvents.END_SERVER_TICK.invoker()).onEndTick((MinecraftServer)this);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/server/world/ServerWorld;close()V")}, method={"shutdown"}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private void closeWorld(CallbackInfo ci, Iterator<class_3218> worlds, class_3218 serverWorld) {
        List entities = serverWorld.method_18198(null, entity -> true);
        for (class_2586 blockEntity : serverWorld.field_9231) {
            ((ServerBlockEntityEvents.Unload)ServerBlockEntityEvents.BLOCK_ENTITY_UNLOAD.invoker()).onUnload(blockEntity, serverWorld);
        }
    }
}

