/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.event.lifecycle;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerBlockEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_5350;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin {
    @Shadow
    private class_5350 field_25318;

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;setupServer()Z")}, method={"method_29741"})
    private void beforeSetupServer(CallbackInfo info) {
        ((ServerLifecycleEvents.ServerStarting)ServerLifecycleEvents.SERVER_STARTING.invoker()).onServerStarting((MinecraftServer)this);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;setFavicon(Lnet/minecraft/server/ServerMetadata;)V", ordinal=0)}, method={"method_29741"})
    private void afterSetupServer(CallbackInfo info) {
        ((ServerLifecycleEvents.ServerStarted)ServerLifecycleEvents.SERVER_STARTED.invoker()).onServerStarted((MinecraftServer)this);
    }

    @Inject(at={@At(value="HEAD")}, method={"shutdown"})
    private void beforeShutdownServer(CallbackInfo info) {
        ((ServerLifecycleEvents.ServerStopping)ServerLifecycleEvents.SERVER_STOPPING.invoker()).onServerStopping((MinecraftServer)this);
    }

    @Inject(at={@At(value="TAIL")}, method={"shutdown"})
    private void afterShutdownServer(CallbackInfo info) {
        ((ServerLifecycleEvents.ServerStopped)ServerLifecycleEvents.SERVER_STOPPED.invoker()).onServerStopped((MinecraftServer)this);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;tickWorlds(Ljava/util/function/BooleanSupplier;)V")}, method={"tick"})
    private void onStartTick(BooleanSupplier shouldKeepTicking, CallbackInfo ci) {
        ((ServerTickEvents.StartTick)ServerTickEvents.START_SERVER_TICK.invoker()).onStartTick((MinecraftServer)this);
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void onEndTick(BooleanSupplier shouldKeepTicking, CallbackInfo info) {
        ((ServerTickEvents.EndTick)ServerTickEvents.END_SERVER_TICK.invoker()).onEndTick((MinecraftServer)this);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/server/world/ServerWorld;close()V")}, method={"shutdown"}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private void closeWorld(CallbackInfo ci, Iterator<class_3218> worlds, class_3218 serverWorld) {
        for (class_2586 blockEntity : serverWorld.field_9231) {
            ((ServerBlockEntityEvents.Unload)ServerBlockEntityEvents.BLOCK_ENTITY_UNLOAD.invoker()).onUnload(blockEntity, serverWorld);
        }
    }

    @Redirect(method={"createWorlds"}, at=@At(value="INVOKE", target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"))
    private <K, V> V onLoadWorld(Map<K, V> worlds, K registryKey, V serverWorld) {
        V result = worlds.put(registryKey, serverWorld);
        ((ServerWorldEvents.Load)ServerWorldEvents.LOAD.invoker()).onWorldLoad((MinecraftServer)this, (class_3218)serverWorld);
        return result;
    }

    @Inject(method={"reloadResources"}, at={@At(value="HEAD")})
    private void startResourceReload(Collection<String> collection, CallbackInfoReturnable<CompletableFuture<Void>> cir) {
        ((ServerLifecycleEvents.StartDataPackReload)ServerLifecycleEvents.START_DATA_PACK_RELOAD.invoker()).startDataPackReload((MinecraftServer)this, this.field_25318);
    }

    @Inject(method={"reloadResources"}, at={@At(value="TAIL")})
    private void endResourceReload(Collection<String> collection, CallbackInfoReturnable<CompletableFuture<Void>> cir) {
        ((CompletableFuture)cir.getReturnValue()).handleAsync((value, throwable) -> {
            ((ServerLifecycleEvents.EndDataPackReload)ServerLifecycleEvents.END_DATA_PACK_RELOAD.invoker()).endDataPackReload((MinecraftServer)this, this.field_25318, throwable == null);
            return value;
        }, (Executor)((MinecraftServer)this));
    }
}

