/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.client.event.lifecycle.v1;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_2818;
import net.minecraft.class_3695;
import net.minecraft.class_638;

@Environment(EnvType.CLIENT)
public final class ClientChunkEvents {
	private ClientChunkEvents() {
	}

	/**
	 * Called when a chunk is loaded into a ClientWorld.
	 *
	 * <p>When this event is called, the chunk is already in the world.
	 */
	public static final Event<ClientChunkEvents.Load> CHUNK_LOAD = EventFactory.createArrayBacked(ClientChunkEvents.Load.class, callbacks -> (clientWorld, chunk) -> {
		if (EventFactory.isProfilingEnabled()) {
			class_3695 profiler = clientWorld.method_16107();
			profiler.method_15396("fabricClientChunkLoad");

			for (ClientChunkEvents.Load callback : callbacks) {
				profiler.method_15396(EventFactory.getHandlerName(callback));
				callback.onChunkLoad(clientWorld, chunk);
				profiler.method_15407();
			}

			profiler.method_15407();
		} else {
			for (ClientChunkEvents.Load callback : callbacks) {
				callback.onChunkLoad(clientWorld, chunk);
			}
		}
	});

	/**
	 * Called when a chunk is about to be unloaded from a ClientWorld.
	 *
	 * <p>When this event is called, the chunk is still present in the world.
	 */
	public static final Event<ClientChunkEvents.Unload> CHUNK_UNLOAD = EventFactory.createArrayBacked(ClientChunkEvents.Unload.class, callbacks -> (clientWorld, chunk) -> {
		if (EventFactory.isProfilingEnabled()) {
			final class_3695 profiler = clientWorld.method_16107();
			profiler.method_15396("fabricClientChunkUnload");

			for (ClientChunkEvents.Unload callback : callbacks) {
				profiler.method_15396(EventFactory.getHandlerName(callback));
				callback.onChunkUnload(clientWorld, chunk);
				profiler.method_15407();
			}

			profiler.method_15407();
		} else {
			for (ClientChunkEvents.Unload callback : callbacks) {
				callback.onChunkUnload(clientWorld, chunk);
			}
		}
	});

	public interface Load {
		void onChunkLoad(class_638 world, class_2818 chunk);
	}

	public interface Unload {
		void onChunkUnload(class_638 world, class_2818 chunk);
	}
}
