/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.event.lifecycle.client;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientBlockEntityEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.mixin.event.lifecycle.WorldMixin;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3695;
import net.minecraft.class_638;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_638.class})
public abstract class ClientWorldMixin
extends WorldMixin {
    @Inject(method={"addEntityPrivate"}, at={@At(value="TAIL")})
    private void onEntityLoad(int id, class_1297 entity, CallbackInfo ci) {
        ((ClientEntityEvents.Load)ClientEntityEvents.ENTITY_LOAD.invoker()).onLoad(entity, (class_638)this);
    }

    @Inject(method={"finishRemovingEntity"}, at={@At(value="HEAD")})
    private void onEntityUnload(class_1297 entity, CallbackInfo ci) {
        ((ClientEntityEvents.Unload)ClientEntityEvents.ENTITY_UNLOAD.invoker()).onUnload(entity, (class_638)this);
    }

    @Override
    protected void onLoadBlockEntity(class_2586 blockEntity, CallbackInfoReturnable<Boolean> cir) {
        ((ClientBlockEntityEvents.Load)ClientBlockEntityEvents.BLOCK_ENTITY_LOAD.invoker()).onLoad(blockEntity, (class_638)this);
    }

    @Override
    protected void onUnloadBlockEntity(class_2338 pos, CallbackInfo ci, class_2586 blockEntity) {
        ((ClientBlockEntityEvents.Unload)ClientBlockEntityEvents.BLOCK_ENTITY_UNLOAD.invoker()).onUnload(blockEntity, (class_638)this);
    }

    @Override
    protected void onRemoveBlockEntity(CallbackInfo ci, class_3695 profiler, Iterator iterator, class_2586 blockEntity) {
        ((ClientBlockEntityEvents.Unload)ClientBlockEntityEvents.BLOCK_ENTITY_UNLOAD.invoker()).onUnload(blockEntity, (class_638)this);
    }

    @Override
    protected boolean onPurgeRemovedBlockEntities(List<class_2586> blockEntityList, Collection<class_2586> removals) {
        for (class_2586 removal : removals) {
            ((ClientBlockEntityEvents.Unload)ClientBlockEntityEvents.BLOCK_ENTITY_UNLOAD.invoker()).onUnload(removal, (class_638)this);
        }
        return super.onPurgeRemovedBlockEntities(blockEntityList, removals);
    }

    @Override
    protected void tickWorldAfterBlockEntities(CallbackInfo ci) {
        ((ClientTickEvents.EndWorldTick)ClientTickEvents.END_WORLD_TICK.invoker()).onEndTick((class_638)this);
    }

    @Inject(method={"tickEntities"}, at={@At(value="HEAD")})
    private void startWorldTick(CallbackInfo ci) {
        ((ClientTickEvents.StartWorldTick)ClientTickEvents.START_WORLD_TICK.invoker()).onStartTick((class_638)this);
    }
}

